/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.NeedGarbageCollection;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.utils.HookSet;
import pro.gravit.utils.helper.IOHelper;

public class SessionManager
implements NeedGarbageCollection {
    private final LaunchServer server;
    public HookSet<Client> clientRestoreHook = new HookSet();

    public SessionManager(LaunchServer server) {
        this.server = server;
    }

    public boolean addClient(Client client) {
        if (client == null || client.session == null) {
            return false;
        }
        return this.server.config.sessions.writeSession(client.uuid, client.session, this.compressClient(client));
    }

    public Stream<UUID> findSessionsByUUID(UUID uuid) {
        return this.server.config.sessions.getSessionsFromUserUUID(uuid);
    }

    public boolean removeByUUID(UUID uuid) {
        return this.server.config.sessions.deleteSessionsByUserUUID(uuid);
    }

    public void clear() {
        this.server.config.sessions.clear();
    }

    private byte[] compressClient(Client client) {
        return IOHelper.encode((String)Launcher.gsonManager.gson.toJson((Object)client));
    }

    private Client decompressClient(byte[] client) {
        return (Client)Launcher.gsonManager.gson.fromJson(IOHelper.decode((byte[])client), Client.class);
    }

    private Client restoreFromString(byte[] data) {
        Client result = this.decompressClient(data);
        result.updateAuth(this.server);
        if (result.auth != null && result.username != null) {
            result.coreObject = result.auth.core.getUserByUUID(result.uuid);
        }
        if (result.refCount == null) {
            result.refCount = new AtomicInteger(1);
        }
        this.clientRestoreHook.hook((Object)result);
        return result;
    }

    public void garbageCollection() {
    }

    public Client getClient(UUID session) {
        if (session == null) {
            return null;
        }
        byte[] data = this.server.config.sessions.getSessionData(session);
        if (data == null) {
            return null;
        }
        return this.restoreFromString(data);
    }

    public Client getOrNewClient(UUID session) {
        Client client = this.getClient(session);
        return client == null ? new Client(session) : client;
    }

    public boolean remove(UUID session) {
        return this.server.config.sessions.deleteSession(session);
    }
}

