/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket;

import com.google.gson.Gson;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.ChannelMatchers;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Type;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.WebSocketServerResponse;
import pro.gravit.launchserver.socket.response.auth.AdditionalDataResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.CheckServerResponse;
import pro.gravit.launchserver.socket.response.auth.CurrentUserResponse;
import pro.gravit.launchserver.socket.response.auth.ExitResponse;
import pro.gravit.launchserver.socket.response.auth.GetAvailabilityAuthResponse;
import pro.gravit.launchserver.socket.response.auth.JoinServerResponse;
import pro.gravit.launchserver.socket.response.auth.ProfilesResponse;
import pro.gravit.launchserver.socket.response.auth.RefreshTokenResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreSessionResponse;
import pro.gravit.launchserver.socket.response.auth.SetProfileResponse;
import pro.gravit.launchserver.socket.response.management.FeaturesResponse;
import pro.gravit.launchserver.socket.response.management.PingServerReportResponse;
import pro.gravit.launchserver.socket.response.management.PingServerResponse;
import pro.gravit.launchserver.socket.response.management.ServerStatusResponse;
import pro.gravit.launchserver.socket.response.profile.BatchProfileByUsername;
import pro.gravit.launchserver.socket.response.profile.ProfileByUUIDResponse;
import pro.gravit.launchserver.socket.response.profile.ProfileByUsername;
import pro.gravit.launchserver.socket.response.secure.GetSecureLevelInfoResponse;
import pro.gravit.launchserver.socket.response.secure.HardwareReportResponse;
import pro.gravit.launchserver.socket.response.secure.SecurityReportResponse;
import pro.gravit.launchserver.socket.response.secure.VerifySecureLevelKeyResponse;
import pro.gravit.launchserver.socket.response.update.LauncherResponse;
import pro.gravit.launchserver.socket.response.update.UpdateListResponse;
import pro.gravit.launchserver.socket.response.update.UpdateResponse;
import pro.gravit.utils.BiHookSet;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.helper.IOHelper;

public class WebSocketService {
    public static final ProviderMap<WebSocketServerResponse> providers = new ProviderMap();
    public final ChannelGroup channels;
    public final BiHookSet<WebSocketRequestContext, ChannelHandlerContext> hook = new BiHookSet();
    public final AtomicLong shortRequestLatency = new AtomicLong();
    public final AtomicLong shortRequestCounter = new AtomicLong();
    public final AtomicLong middleRequestLatency = new AtomicLong();
    public final AtomicLong middleRequestCounter = new AtomicLong();
    public final AtomicLong longRequestLatency = new AtomicLong();
    public final AtomicLong longRequestCounter = new AtomicLong();
    public final AtomicLong lastRequestTime = new AtomicLong();
    private final LaunchServer server;
    private final Gson gson;
    private final transient Logger logger = LogManager.getLogger();

    public WebSocketService(ChannelGroup channels, LaunchServer server) {
        this.channels = channels;
        this.server = server;
        this.gson = Launcher.gsonManager.gson;
    }

    public static void registerResponses() {
        providers.register("auth", AuthResponse.class);
        providers.register("checkServer", CheckServerResponse.class);
        providers.register("joinServer", JoinServerResponse.class);
        providers.register("profiles", ProfilesResponse.class);
        providers.register("launcher", LauncherResponse.class);
        providers.register("updateList", UpdateListResponse.class);
        providers.register("setProfile", SetProfileResponse.class);
        providers.register("update", UpdateResponse.class);
        providers.register("restoreSession", RestoreSessionResponse.class);
        providers.register("batchProfileByUsername", BatchProfileByUsername.class);
        providers.register("profileByUsername", ProfileByUsername.class);
        providers.register("profileByUUID", ProfileByUUIDResponse.class);
        providers.register("getAvailabilityAuth", GetAvailabilityAuthResponse.class);
        providers.register("exit", ExitResponse.class);
        providers.register("getSecureLevelInfo", GetSecureLevelInfoResponse.class);
        providers.register("verifySecureLevelKey", VerifySecureLevelKeyResponse.class);
        providers.register("securityReport", SecurityReportResponse.class);
        providers.register("hardwareReport", HardwareReportResponse.class);
        providers.register("serverStatus", ServerStatusResponse.class);
        providers.register("pingServerReport", PingServerReportResponse.class);
        providers.register("pingServer", PingServerResponse.class);
        providers.register("currentUser", CurrentUserResponse.class);
        providers.register("features", FeaturesResponse.class);
        providers.register("refreshToken", RefreshTokenResponse.class);
        providers.register("restore", RestoreResponse.class);
        providers.register("additionalData", AdditionalDataResponse.class);
    }

    public void forEachActiveChannels(BiConsumer<Channel, WebSocketFrameHandler> callback) {
        for (Channel channel : this.channels) {
            WebSocketFrameHandler wsHandler;
            if (channel == null || channel.pipeline() == null || (wsHandler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class)) == null) continue;
            callback.accept(channel, wsHandler);
        }
    }

    public void process(ChannelHandlerContext ctx, TextWebSocketFrame frame, Client client, String ip) {
        long startTimeNanos = System.nanoTime();
        String request = frame.text();
        WebSocketServerResponse response = (WebSocketServerResponse)this.gson.fromJson(request, WebSocketServerResponse.class);
        if (response == null) {
            ErrorRequestEvent event = new ErrorRequestEvent("This type of request is not supported");
            this.sendObject(ctx, (Object)event);
            return;
        }
        this.process(ctx, response, client, ip);
        long executeTime = System.nanoTime() - startTimeNanos;
        if (executeTime > 0L) {
            this.addRequestTimeToStats(executeTime);
        }
    }

    public void addRequestTimeToStats(long nanos) {
        if (nanos < 100000000L) {
            this.shortRequestCounter.getAndIncrement();
            this.shortRequestLatency.getAndAdd(nanos);
        } else if (nanos < 1000000000L) {
            this.middleRequestCounter.getAndIncrement();
            this.middleRequestLatency.getAndAdd(nanos);
        } else {
            this.longRequestCounter.getAndIncrement();
            this.longRequestLatency.getAndAdd(nanos);
        }
        long lastTime = this.lastRequestTime.get();
        long currentTime = System.currentTimeMillis();
        if (currentTime - lastTime > 60000L) {
            this.lastRequestTime.set(currentTime);
            this.shortRequestLatency.set(0L);
            this.shortRequestCounter.set(0L);
            this.middleRequestCounter.set(0L);
            this.middleRequestLatency.set(0L);
            this.longRequestCounter.set(0L);
            this.longRequestLatency.set(0L);
        }
    }

    void process(ChannelHandlerContext ctx, WebSocketServerResponse response, Client client, String ip) {
        WebSocketRequestContext context = new WebSocketRequestContext(response, client, ip);
        if (this.hook.hook((Object)context, (Object)ctx)) {
            return;
        }
        if (response instanceof SimpleResponse) {
            SimpleResponse simpleResponse = (SimpleResponse)response;
            simpleResponse.server = this.server;
            simpleResponse.service = this;
            simpleResponse.ctx = ctx;
            simpleResponse.ip = ip != null ? ip : IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress());
        }
        try {
            response.execute(ctx, client);
        }
        catch (Exception e) {
            this.logger.error("WebSocket request processing failed", (Throwable)e);
            ErrorRequestEvent event = new ErrorRequestEvent("Fatal server error. Contact administrator");
            if (response instanceof SimpleResponse) {
                event.requestUUID = ((SimpleResponse)response).requestUUID;
            }
            this.sendObject(ctx, (Object)event);
        }
    }

    public void registerClient(Channel channel) {
        this.channels.add((Object)channel);
    }

    public void sendObject(ChannelHandlerContext ctx, Object obj) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class)), ctx.voidPromise());
    }

    public void sendObject(ChannelHandlerContext ctx, Object obj, Type type) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type)), ctx.voidPromise());
    }

    public void sendObject(Channel channel, Object obj) {
        channel.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class)), channel.voidPromise());
    }

    public void sendObject(Channel channel, Object obj, Type type) {
        channel.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type)), channel.voidPromise());
    }

    public void sendObjectAll(Object obj) {
        for (Channel ch : this.channels) {
            ch.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class)), ch.voidPromise());
        }
    }

    public void sendObjectAll(Object obj, Type type) {
        for (Channel ch : this.channels) {
            ch.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type)), ch.voidPromise());
        }
    }

    public void sendObjectToUUID(UUID userUuid, Object obj, Type type) {
        for (Channel ch : this.channels) {
            Client client;
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || (client = wsHandler.getClient()) == null || !userUuid.equals(client.uuid)) continue;
            ch.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type)), ch.voidPromise());
        }
    }

    public Channel getChannelFromConnectUUID(UUID connectUuid) {
        for (Channel ch : this.channels) {
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || !connectUuid.equals(wsHandler.getConnectUUID())) continue;
            return ch;
        }
        return null;
    }

    public boolean kickByUserUUID(UUID userUuid, boolean isClose) {
        boolean result = false;
        for (Channel ch : this.channels) {
            Client client;
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || (client = wsHandler.getClient()) == null || !userUuid.equals(client.uuid)) continue;
            ExitResponse.exit(this.server, wsHandler, ch, ExitRequestEvent.ExitReason.SERVER);
            if (isClose) {
                ch.close();
            }
            result = true;
        }
        return result;
    }

    public boolean kickByConnectUUID(UUID connectUuid, boolean isClose) {
        for (Channel ch : this.channels) {
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || !connectUuid.equals(wsHandler.getConnectUUID())) continue;
            ExitResponse.exit(this.server, wsHandler, ch, ExitRequestEvent.ExitReason.SERVER);
            if (isClose) {
                ch.close();
            }
            return true;
        }
        return false;
    }

    public boolean kickByIP(String ip, boolean isClose) {
        boolean result = false;
        for (Channel ch : this.channels) {
            String clientIp;
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || !ip.equals(clientIp = wsHandler.context != null && wsHandler.context.ip != null ? wsHandler.context.ip : IOHelper.getIP((SocketAddress)ch.remoteAddress()))) continue;
            ExitResponse.exit(this.server, wsHandler, ch, ExitRequestEvent.ExitReason.SERVER);
            if (isClose) {
                ch.close();
            }
            result = true;
        }
        return result;
    }

    public void sendObjectAndClose(ChannelHandlerContext ctx, Object obj) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, WebSocketEvent.class))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendObjectAndClose(ChannelHandlerContext ctx, Object obj, Type type) {
        ctx.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson(obj, type))).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendEvent(EventResult obj) {
        this.channels.writeAndFlush((Object)new TextWebSocketFrame(this.gson.toJson((Object)obj)), ChannelMatchers.all(), true);
    }

    public static class WebSocketRequestContext {
        public final WebSocketServerResponse response;
        public final Client client;
        public final String ip;

        public WebSocketRequestContext(WebSocketServerResponse response, Client client, String ip) {
            this.response = response;
            this.client = client;
            this.ip = ip;
        }
    }

    public static class EventResult
    implements WebSocketEvent {
        public String getType() {
            return "event";
        }
    }
}

