/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.serialize.HOutput;
import pro.gravit.launcher.serialize.stream.StreamObject;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class BuildContext {
    public final ZipOutputStream output;
    public final List<JarFile> readerClassPath;
    public final MainBuildTask task;
    public final HashSet<String> fileList;
    public final HashSet<String> clientModules;

    public BuildContext(ZipOutputStream output, List<JarFile> readerClassPath, MainBuildTask task) {
        this.output = output;
        this.readerClassPath = readerClassPath;
        this.task = task;
        this.fileList = new HashSet(1024);
        this.clientModules = new HashSet();
    }

    public void pushFile(String filename, InputStream inputStream) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        IOHelper.transfer((InputStream)inputStream, (OutputStream)this.output);
        this.output.closeEntry();
        this.fileList.add(filename);
    }

    public void pushFile(String filename, StreamObject object) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        object.write(new HOutput((OutputStream)this.output));
        this.output.closeEntry();
        this.fileList.add(filename);
    }

    public void pushFile(String filename, Object object, Type type) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        try (BufferedWriter w = IOHelper.newWriter((OutputStream)IOHelper.nonClosing((OutputStream)this.output));){
            Launcher.gsonManager.gson.toJson(object, type);
        }
        this.output.closeEntry();
        this.fileList.add(filename);
        this.pushBytes(filename, IOHelper.encode((String)Launcher.gsonManager.gson.toJson(object, type)));
    }

    public void pushDir(Path dir, String targetDir, Map<String, byte[]> hashMap, boolean hidden) throws IOException {
        IOHelper.walk((Path)dir, (FileVisitor)new RuntimeDirVisitor(this.output, hashMap, dir, targetDir), (boolean)hidden);
    }

    public void pushEncryptedDir(Path dir, String targetDir, String aesHexKey, Map<String, byte[]> hashMap, boolean hidden) throws IOException {
        IOHelper.walk((Path)dir, (FileVisitor)new EncryptedRuntimeDirVisitor(this.output, aesHexKey, hashMap, dir, targetDir), (boolean)hidden);
    }

    public void pushBytes(String filename, byte[] bytes) throws IOException {
        ZipEntry zip = IOHelper.newZipEntry((String)filename);
        this.output.putNextEntry(zip);
        this.output.write(bytes);
        this.output.closeEntry();
        this.fileList.add(filename);
    }

    public void pushJarFile(Path jarfile, Predicate<ZipEntry> filter, Predicate<String> needTransform) throws IOException {
        this.pushJarFile(jarfile.toUri().toURL(), filter, needTransform);
    }

    public void pushJarFile(URL jarfile, Predicate<ZipEntry> filter, Predicate<String> needTransform) throws IOException {
        try (ZipInputStream input = new ZipInputStream(IOHelper.newInput((URL)jarfile));){
            ZipEntry e = input.getNextEntry();
            while (e != null) {
                String filename = e.getName();
                if (e.isDirectory() || this.fileList.contains(filename) || filter.test(e)) {
                    e = input.getNextEntry();
                    continue;
                }
                this.output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
                if (filename.endsWith(".class")) {
                    String classname = filename.replace('/', '.').substring(0, filename.length() - ".class".length());
                    if (!needTransform.test(classname)) {
                        IOHelper.transfer((InputStream)input, (OutputStream)this.output);
                    } else {
                        byte[] bytes = IOHelper.read((InputStream)input);
                        bytes = this.task.transformClass(bytes, classname, this);
                        this.output.write(bytes);
                    }
                } else {
                    IOHelper.transfer((InputStream)input, (OutputStream)this.output);
                }
                this.fileList.add(filename);
                e = input.getNextEntry();
            }
        }
    }

    private static final class RuntimeDirVisitor
    extends SimpleFileVisitor<Path> {
        private final ZipOutputStream output;
        private final Map<String, byte[]> hashs;
        private final Path sourceDir;
        private final String targetDir;

        private RuntimeDirVisitor(ZipOutputStream output, Map<String, byte[]> hashs, Path sourceDir, String targetDir) {
            this.output = output;
            this.hashs = hashs;
            this.sourceDir = sourceDir;
            this.targetDir = targetDir;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            String dirName = IOHelper.toString((Path)this.sourceDir.relativize(dir));
            this.output.putNextEntry(this.newEntry(dirName + "/"));
            return super.preVisitDirectory(dir, attrs);
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            String fileName = IOHelper.toString((Path)this.sourceDir.relativize(file));
            if (this.hashs != null) {
                this.hashs.put(fileName, SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)file));
            }
            this.output.putNextEntry(this.newEntry(fileName));
            IOHelper.transfer((Path)file, (OutputStream)this.output);
            return super.visitFile(file, attrs);
        }

        private ZipEntry newEntry(String fileName) {
            return IOHelper.newZipEntry((String)(this.targetDir + "/" + fileName));
        }
    }

    private static final class EncryptedRuntimeDirVisitor
    extends SimpleFileVisitor<Path> {
        private final ZipOutputStream output;
        private final Map<String, byte[]> hashs;
        private final Path sourceDir;
        private final String targetDir;
        private final SecretKeySpec sKeySpec;
        private final IvParameterSpec iKeySpec;
        private final transient Logger logger = LogManager.getLogger();

        private EncryptedRuntimeDirVisitor(ZipOutputStream output, String aesKey, Map<String, byte[]> hashs, Path sourceDir, String targetDir) {
            this.output = output;
            this.hashs = hashs;
            this.sourceDir = sourceDir;
            this.targetDir = targetDir;
            try {
                byte[] key = SecurityHelper.fromHex((String)aesKey);
                byte[] compatKey = SecurityHelper.getAESKey((byte[])key);
                this.sKeySpec = new SecretKeySpec(compatKey, "AES/CBC/PKCS5Padding");
                this.iKeySpec = new IvParameterSpec(IOHelper.encode((String)"8u3d90ikr7o67lsq"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            byte[] digest = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.MD5, (Path)file);
            String fileName = IOHelper.toString((Path)this.sourceDir.relativize(file));
            if (this.hashs != null) {
                this.hashs.put(fileName, digest);
            }
            try {
                this.output.putNextEntry(this.newEntry(SecurityHelper.toHex((byte[])digest)));
            }
            catch (ZipException e) {
                return super.visitFile(file, attrs);
            }
            Cipher cipher = null;
            try {
                cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
                cipher.init(1, (Key)this.sKeySpec, this.iKeySpec);
            }
            catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
            try (CipherOutputStream stream = new CipherOutputStream(new NoCloseOutputStream(this.output), cipher);){
                IOHelper.transfer((Path)file, (OutputStream)stream);
            }
            return super.visitFile(file, attrs);
        }

        private ZipEntry newEntry(String fileName) {
            return IOHelper.newZipEntry((String)(this.targetDir + "/" + fileName));
        }

        private static class NoCloseOutputStream
        extends OutputStream {
            private final OutputStream stream;

            private NoCloseOutputStream(OutputStream stream) {
                this.stream = stream;
            }

            @Override
            public void write(int i) throws IOException {
                this.stream.write(i);
            }

            @Override
            public void write(byte[] b) throws IOException {
                this.stream.write(b);
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                this.stream.write(b, off, len);
            }

            @Override
            public void flush() throws IOException {
                this.stream.flush();
            }
        }
    }
}

