/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.config;

import io.netty.channel.epoll.Epoll;
import io.netty.handler.logging.LogLevel;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherConfig;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.RejectAuthCoreProvider;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.StdProtectHandler;
import pro.gravit.launchserver.auth.session.MemorySessionStorage;
import pro.gravit.launchserver.auth.session.SessionStorage;
import pro.gravit.launchserver.auth.texture.RequestTextureProvider;
import pro.gravit.launchserver.components.AuthLimiterComponent;
import pro.gravit.launchserver.components.Component;
import pro.gravit.launchserver.components.ProGuardComponent;
import pro.gravit.launchserver.components.RegLimiterComponent;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.JVMHelper;

public final class LaunchServerConfig {
    private final transient Logger logger = LogManager.getLogger();
    public String projectName;
    public String[] mirrors;
    public String binaryName;
    public boolean copyBinaries = true;
    public boolean cacheUpdates = true;
    public LauncherConfig.LauncherEnvironment env;
    public Map<String, AuthProviderPair> auth;
    public SessionStorage sessions;
    public ProtectHandler protectHandler;
    public Map<String, Component> components;
    public ExeConf launch4j;
    public NettyConfig netty;
    public LauncherConf launcher;
    public JarSignerConf sign;
    public String startScript;
    private transient LaunchServer server = null;
    private transient AuthProviderPair authDefault;

    public static LaunchServerConfig getDefault(LaunchServer.LaunchServerEnv env) {
        LaunchServerConfig newConfig = new LaunchServerConfig();
        newConfig.mirrors = new String[]{"https://mirror.gravit.pro/", "https://gravit-launcher-mirror.storage.googleapis.com/"};
        newConfig.launch4j = new ExeConf();
        newConfig.launch4j.enabled = true;
        newConfig.launch4j.copyright = "\u00a9 GravitLauncher Team";
        newConfig.launch4j.fileDesc = "GravitLauncher ".concat(Version.getVersion().getVersionString());
        newConfig.launch4j.fileVer = Version.getVersion().getVersionString().concat(".").concat(String.valueOf(Version.getVersion().patch));
        newConfig.launch4j.internalName = "Launcher";
        newConfig.launch4j.trademarks = "This product is licensed under GPLv3";
        newConfig.launch4j.txtFileVersion = "%s, build %d";
        newConfig.launch4j.txtProductVersion = "%s, build %d";
        newConfig.launch4j.productName = "GravitLauncher";
        newConfig.launch4j.productVer = newConfig.launch4j.fileVer;
        newConfig.launch4j.maxVersion = "1.8.999";
        newConfig.env = LauncherConfig.LauncherEnvironment.STD;
        newConfig.startScript = JVMHelper.OS_TYPE.equals((Object)JVMHelper.OS.MUSTDIE) ? "." + File.separator + "start.bat" : "." + File.separator + "start.sh";
        newConfig.auth = new HashMap<String, AuthProviderPair>();
        AuthProviderPair a = new AuthProviderPair(new RejectAuthCoreProvider(), new RequestTextureProvider("http://example.com/skins/%username%.png", "http://example.com/cloaks/%username%.png"));
        a.displayName = "Default";
        newConfig.auth.put("std", a);
        newConfig.protectHandler = new StdProtectHandler();
        newConfig.sessions = new MemorySessionStorage();
        newConfig.binaryName = "Launcher";
        newConfig.netty = new NettyConfig();
        newConfig.netty.fileServerEnabled = true;
        newConfig.netty.binds = new NettyBindAddress[]{new NettyBindAddress("0.0.0.0", 9274)};
        newConfig.netty.performance = new NettyPerformanceConfig();
        try {
            newConfig.netty.performance.usingEpoll = Epoll.isAvailable();
        }
        catch (Throwable e) {
            newConfig.netty.performance.usingEpoll = false;
        }
        newConfig.netty.performance.bossThread = 2;
        newConfig.netty.performance.workerThread = 8;
        newConfig.netty.performance.schedulerThread = 2;
        newConfig.launcher = new LauncherConf();
        newConfig.launcher.guardType = "no";
        newConfig.launcher.compress = true;
        newConfig.launcher.deleteTempFiles = true;
        newConfig.launcher.stripLineNumbers = true;
        newConfig.sign = new JarSignerConf();
        newConfig.components = new HashMap<String, Component>();
        AuthLimiterComponent authLimiterComponent = new AuthLimiterComponent();
        authLimiterComponent.rateLimit = 3;
        authLimiterComponent.rateLimitMillis = 8000;
        authLimiterComponent.message = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0430\u0432\u0442\u043e\u0440\u0438\u0437\u0430\u0446\u0438\u0439";
        newConfig.components.put("authLimiter", authLimiterComponent);
        RegLimiterComponent regLimiterComponent = new RegLimiterComponent();
        regLimiterComponent.rateLimit = 3;
        regLimiterComponent.rateLimitMillis = 36000000;
        regLimiterComponent.message = "\u041f\u0440\u0435\u0432\u044b\u0448\u0435\u043d \u043b\u0438\u043c\u0438\u0442 \u0440\u0435\u0433\u0438\u0441\u0442\u0440\u0430\u0446\u0438\u0439";
        newConfig.components.put("regLimiter", regLimiterComponent);
        ProGuardComponent proGuardComponent = new ProGuardComponent();
        newConfig.components.put("proguard", proGuardComponent);
        return newConfig;
    }

    public LaunchServerConfig setLaunchServer(LaunchServer server) {
        this.server = server;
        return this;
    }

    public AuthProviderPair getAuthProviderPair(String name) {
        return this.auth.get(name);
    }

    public AuthProviderPair getAuthProviderPair() {
        if (this.authDefault != null) {
            return this.authDefault;
        }
        for (AuthProviderPair pair : this.auth.values()) {
            if (!pair.isDefault) continue;
            this.authDefault = pair;
            return pair;
        }
        throw new IllegalStateException("Default AuthProviderPair not found");
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public void setBinaryName(String binaryName) {
        this.binaryName = binaryName;
    }

    public void setEnv(LauncherConfig.LauncherEnvironment env) {
        this.env = env;
    }

    public void verify() {
        if (this.auth == null || this.auth.size() < 1) {
            throw new NullPointerException("AuthProviderPair`s count should be at least one");
        }
        boolean isOneDefault = false;
        for (AuthProviderPair pair : this.auth.values()) {
            if (!pair.isDefault) continue;
            isOneDefault = true;
            break;
        }
        if (this.protectHandler == null) {
            throw new NullPointerException("ProtectHandler must not be null");
        }
        if (!isOneDefault) {
            throw new IllegalStateException("No auth pairs declared by default.");
        }
        if (this.env == null) {
            throw new NullPointerException("Env must not be null");
        }
        if (this.netty == null) {
            throw new NullPointerException("Netty must not be null");
        }
    }

    public void init(LaunchServer.ReloadType type) {
        Launcher.applyLauncherEnv((LauncherConfig.LauncherEnvironment)this.env);
        for (Map.Entry<String, AuthProviderPair> provider : this.auth.entrySet()) {
            provider.getValue().init(this.server, provider.getKey());
        }
        if (this.protectHandler != null) {
            this.server.registerObject("protectHandler", this.protectHandler);
            this.protectHandler.init(this.server);
            this.protectHandler.checkLaunchServerLicense();
        }
        if (this.sessions != null) {
            this.sessions.init(this.server);
            this.server.registerObject("sessions", this.sessions);
        }
        if (this.components != null) {
            this.components.forEach((k, v) -> this.server.registerObject("component.".concat((String)k), v));
        }
        if (!type.equals((Object)LaunchServer.ReloadType.NO_AUTH)) {
            for (AuthProviderPair pair : this.auth.values()) {
                this.server.registerObject("auth.".concat(pair.name).concat(".core"), pair.core);
                this.server.registerObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
            }
        }
        Arrays.stream(this.mirrors).forEach(this.server.mirrorManager::addMirror);
    }

    public void close(LaunchServer.ReloadType type) {
        try {
            if (!type.equals((Object)LaunchServer.ReloadType.NO_AUTH)) {
                for (AuthProviderPair pair : this.auth.values()) {
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".core"), pair.core);
                    this.server.unregisterObject("auth.".concat(pair.name).concat(".texture"), pair.textureProvider);
                    pair.close();
                }
            }
            if (type.equals((Object)LaunchServer.ReloadType.FULL)) {
                this.components.forEach((k, component) -> {
                    this.server.unregisterObject("component.".concat((String)k), component);
                    if (component instanceof AutoCloseable) {
                        try {
                            ((AutoCloseable)((Object)component)).close();
                        }
                        catch (Exception e) {
                            this.logger.error((Object)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        if (this.protectHandler != null) {
            this.server.unregisterObject("protectHandler", this.protectHandler);
            this.protectHandler.close();
        }
        if (this.sessions != null) {
            this.server.unregisterObject("sessions", this.sessions);
            if (this.sessions instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)((Object)this.sessions)).close();
                }
                catch (Exception e) {
                    this.logger.error((Object)e);
                }
            }
        }
    }

    public static class ExeConf {
        public boolean enabled;
        public boolean setMaxVersion;
        public String maxVersion;
        public String minVersion = "1.8.0";
        public String supportURL = null;
        public String downloadUrl = "http://www.oracle.com/technetwork/java/javase/downloads/jre8-downloads-2133155.html";
        public String productName;
        public String productVer;
        public String fileDesc;
        public String fileVer;
        public String internalName;
        public String copyright;
        public String trademarks;
        public String txtFileVersion;
        public String txtProductVersion;
    }

    public static class NettyConfig {
        public boolean fileServerEnabled;
        @Deprecated
        public boolean sendExceptionEnabled;
        public boolean ipForwarding;
        public boolean disableWebApiInterface;
        public boolean showHiddenFiles;
        public String launcherURL;
        public String downloadURL;
        public String launcherEXEURL;
        public String address;
        public Map<String, NettyUpdatesBind> bindings = new HashMap<String, NettyUpdatesBind>();
        public NettyPerformanceConfig performance;
        public NettyBindAddress[] binds;
        public LogLevel logLevel = LogLevel.DEBUG;
    }

    public static class NettyBindAddress {
        public String address;
        public int port;

        public NettyBindAddress(String address, int port) {
            this.address = address;
            this.port = port;
        }
    }

    public static class NettyPerformanceConfig {
        public boolean usingEpoll;
        public int bossThread;
        public int workerThread;
        public int schedulerThread;
        public long sessionLifetimeMs = 86400000L;
        public int maxWebSocketRequestBytes = 0x100000;
    }

    public static class LauncherConf {
        public String guardType;
        public boolean compress;
        public boolean stripLineNumbers;
        public boolean deleteTempFiles;
        public boolean certificatePinning;
        public boolean encryptRuntime;
        public int memoryLimit = 256;
    }

    public static class JarSignerConf {
        public boolean enabled = false;
        public String keyStore = "pathToKey";
        public String keyStoreType = "JKS";
        public String keyStorePass = "mypass";
        public String keyAlias = "myname";
        public String keyPass = "mypass";
        public String metaInfKeyName = "SIGNUMO.RSA";
        public String metaInfSfName = "SIGNUMO.SF";
        public String signAlgo = "SHA256WITHRSA";
    }

    public static class NettyUpdatesBind {
        public String url;
        public boolean zip;
    }
}

