/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import java.io.File;
import java.nio.file.Files;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum ContentType {
    NONE{

        @Override
        public String forPath(File p) {
            return null;
        }
    }
    ,
    NIO{

        @Override
        public String forPath(File p) {
            try {
                return Files.probeContentType(p.toPath());
            }
            catch (Throwable e) {
                return UNIVERSAL.forPath(p);
            }
        }
    }
    ,
    UNIVERSAL{

        @Override
        public String forPath(File p) {
            return "application/octet-stream";
        }
    };


    public abstract String forPath(File var1);
}

