/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.util.UUID;
import pro.gravit.launcher.LauncherNetworkAPI;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.RestoreSessionRequestEvent;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.auth.CurrentUserResponse;

public class RestoreSessionResponse
extends SimpleResponse {
    @LauncherNetworkAPI
    public UUID session;
    public boolean needUserInfo;

    @Override
    public String getType() {
        return "restoreSession";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) throws Exception {
        if (this.session == null) {
            this.sendError("Session invalid");
            return;
        }
        Client[] rClient = new Client[]{null};
        this.service.forEachActiveChannels((channel, handler) -> {
            Client c = handler.getClient();
            if (c != null && this.session.equals(c.session)) {
                rClient[0] = c;
            }
        });
        if (rClient[0] == null) {
            rClient[0] = this.server.sessionManager.getClient(this.session);
        }
        if (rClient[0] == null) {
            this.sendError("Session invalid");
            return;
        }
        if (rClient[0].useOAuth) {
            this.sendError("This session using OAuth. Session restoration not safety");
            return;
        }
        WebSocketFrameHandler frameHandler = (WebSocketFrameHandler)ctx.pipeline().get(WebSocketFrameHandler.class);
        frameHandler.setClient(rClient[0]);
        if (this.needUserInfo) {
            this.sendResult((RequestEvent)new RestoreSessionRequestEvent(CurrentUserResponse.collectUserInfoFromClient(this.server, rClient[0])));
        } else {
            this.sendResult((RequestEvent)new RestoreSessionRequestEvent());
        }
    }
}

