/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.session;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.session.SessionStorage;
import pro.gravit.utils.helper.IOHelper;

public class MemorySessionStorage
extends SessionStorage
implements AutoCloseable {
    private final transient Map<UUID, Entry> clientSet = new ConcurrentHashMap<UUID, Entry>(128);
    private final transient Map<UUID, Set<Entry>> uuidIndex = new ConcurrentHashMap<UUID, Set<Entry>>(32);
    private final transient Logger logger = LogManager.getLogger();
    public boolean autoDump = false;
    public String dumpFile = "sessions.json";

    @Override
    public void init(LaunchServer server) {
        super.init(server);
        if (this.autoDump) {
            this.loadSessionsData();
        }
    }

    @Override
    public byte[] getSessionData(UUID session) {
        Entry e = this.clientSet.get(session);
        if (e == null) {
            return null;
        }
        return e.data;
    }

    @Override
    public Stream<UUID> getSessionsFromUserUUID(UUID userUUID) {
        Set<Entry> set = this.uuidIndex.get(userUUID);
        if (set != null) {
            return set.stream().map(e -> e.sessionUuid);
        }
        return null;
    }

    @Override
    public boolean writeSession(UUID userUUID, UUID sessionUUID, byte[] data) {
        this.deleteSession(sessionUUID);
        Entry e = new Entry(data, sessionUUID);
        this.clientSet.put(sessionUUID, e);
        if (userUUID != null) {
            Set uuidSet = this.uuidIndex.computeIfAbsent(userUUID, k -> ConcurrentHashMap.newKeySet());
            uuidSet.add(e);
        }
        return false;
    }

    @Override
    public boolean deleteSession(UUID sessionUUID) {
        Entry e = this.clientSet.remove(sessionUUID);
        if (e != null) {
            Set<Entry> set = this.uuidIndex.get(sessionUUID);
            if (set != null) {
                this.removeUuidFromIndexSet(set, e, sessionUUID);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean deleteSessionsByUserUUID(UUID userUUID) {
        Set<Entry> set = this.uuidIndex.get(userUUID);
        if (set != null) {
            for (Entry e : set) {
                this.clientSet.remove(e.sessionUuid);
            }
            set.clear();
            this.uuidIndex.remove(userUUID);
        }
        return true;
    }

    @Override
    public void clear() {
        this.clientSet.clear();
        this.uuidIndex.clear();
    }

    public void dumpSessionsData() {
        DumpedData dumpedData = new DumpedData(this.clientSet, this.uuidIndex);
        Path path = Paths.get(this.dumpFile, new String[0]);
        try (BufferedWriter writer = IOHelper.newWriter((Path)path);){
            Launcher.gsonManager.gson.toJson((Object)dumpedData, (Appendable)writer);
        }
        catch (Throwable e) {
            this.logger.error("Sessions can't be saved", e);
        }
    }

    public void loadSessionsData() {
        Path path = Paths.get(this.dumpFile, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        try (BufferedReader reader = IOHelper.newReader((Path)path);){
            DumpedData data = (DumpedData)Launcher.gsonManager.gson.fromJson((Reader)reader, DumpedData.class);
            this.clientSet.putAll(data.clientSet);
            this.uuidIndex.putAll(data.uuidIndex);
        }
        catch (Throwable e) {
            this.logger.error("Sessions can't be loaded", e);
        }
    }

    @Override
    public void lockSession(UUID sessionUUID) {
    }

    @Override
    public void lockUser(UUID userUUID) {
    }

    @Override
    public void unlockSession(UUID sessionUUID) {
    }

    @Override
    public void unlockUser(UUID userUUID) {
    }

    private void removeUuidFromIndexSet(Set<Entry> set, Entry e, UUID session) {
        set.remove(e);
        if (set.isEmpty()) {
            this.uuidIndex.remove(session);
        }
    }

    @Override
    public void close() {
        if (this.autoDump) {
            this.dumpSessionsData();
        }
    }

    private static class Entry {
        public byte[] data;
        public UUID sessionUuid;
        public long timestamp;

        public Entry(byte[] data, UUID sessionUuid) {
            this.data = data;
            this.sessionUuid = sessionUuid;
            this.timestamp = System.currentTimeMillis();
        }
    }

    private static class DumpedData {
        private final Map<UUID, Entry> clientSet;
        private final Map<UUID, Set<Entry>> uuidIndex;

        private DumpedData(Map<UUID, Entry> clientSet, Map<UUID, Set<Entry>> uuidIndex) {
            this.clientSet = clientSet;
            this.uuidIndex = uuidIndex;
        }
    }
}

