/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;

public class CompressBuildTask
implements LauncherBuildTask {
    public final transient LaunchServer server;

    public CompressBuildTask(LaunchServer server) {
        this.server = server;
    }

    @Override
    public String getName() {
        return "compress";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        Path output = this.server.launcherBinary.nextPath(this);
        try (ZipOutputStream outputStream = new ZipOutputStream(IOHelper.newOutput((Path)output));){
            outputStream.setMethod(8);
            outputStream.setLevel(9);
            try (ZipInputStream input = IOHelper.newZipInput((Path)inputFile);){
                ZipEntry e = input.getNextEntry();
                while (e != null) {
                    if (e.isDirectory()) {
                        e = input.getNextEntry();
                        continue;
                    }
                    outputStream.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
                    IOHelper.transfer((InputStream)input, (OutputStream)outputStream);
                    e = input.getNextEntry();
                }
            }
        }
        return output;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }
}

