/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launchserver.HttpRequester;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportProperties;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportTextures;
import pro.gravit.launchserver.helper.HttpHelper;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.CommonHelper;

public class HttpAuthCoreProvider
extends AuthCoreProvider {
    private final transient Logger logger = LogManager.getLogger();
    private transient HttpRequester requester;
    public String bearerToken;
    public String getUserByUsernameUrl;
    public String getUserByLoginUrl;
    public String getUserByUUIDUrl;
    public String getUserByTokenUrl;
    public String getAuthDetails;
    public String refreshTokenUrl;
    public String authorizeUrl;
    public String joinServerUrl;
    public String checkServerUrl;
    public String updateServerIdUrl;

    @Override
    public User getUserByUsername(String username) {
        try {
            return this.requester.send(this.requester.get(CommonHelper.replace((String)this.getUserByUsernameUrl, (String[])new String[]{"username", username}), null), HttpUser.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public User getUserByLogin(String login) {
        if (this.getUserByLoginUrl != null) {
            try {
                return this.requester.send(this.requester.get(CommonHelper.replace((String)this.getUserByLoginUrl, (String[])new String[]{"login", login}), null), HttpUser.class).getOrThrow();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                return null;
            }
        }
        return super.getUserByLogin(login);
    }

    @Override
    public User getUserByUUID(UUID uuid) {
        try {
            return this.requester.send(this.requester.get(CommonHelper.replace((String)this.getUserByUUIDUrl, (String[])new String[]{"uuid", uuid.toString()}), null), HttpUser.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        if (this.getAuthDetails == null) {
            return super.getDetails(client);
        }
        try {
            GetAuthDetailsResponse result = this.requester.send(this.requester.get(this.getAuthDetails, this.bearerToken), GetAuthDetailsResponse.class).getOrThrow();
            return result.details;
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return super.getDetails(client);
        }
    }

    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        if (this.getUserByTokenUrl == null) {
            return null;
        }
        try {
            HttpHelper.HttpOptional<HttpUserSession, HttpRequester.SimpleError> result = this.requester.send(this.requester.get(this.getUserByTokenUrl, accessToken), HttpUserSession.class);
            if (!result.isSuccessful()) {
                String error = result.error().error;
                if (error.equals("auth.expiretoken")) {
                    throw new AuthCoreProvider.OAuthAccessTokenExpired();
                }
                return null;
            }
            return result.getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String refreshToken, AuthResponse.AuthContext context) {
        if (this.refreshTokenUrl == null) {
            return null;
        }
        try {
            return this.requester.send(this.requester.post(this.refreshTokenUrl, new RefreshTokenRequest(refreshToken, context), null), AuthManager.AuthReport.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public AuthManager.AuthReport authorize(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        String error;
        HttpHelper.HttpOptional<HttpAuthReport, HttpRequester.SimpleError> result = this.requester.send(this.requester.post(this.authorizeUrl, new AuthorizeRequest(login, context, password, minecraftAccess), this.bearerToken), HttpAuthReport.class);
        if (!result.isSuccessful() && (error = result.error().error) != null) {
            throw new AuthException(error);
        }
        return result.getOrThrow().toAuthReport();
    }

    @Override
    protected boolean updateServerID(User user, String serverID) throws IOException {
        HttpHelper.HttpOptional<Void, HttpRequester.SimpleError> result = this.requester.send(this.requester.post(this.updateServerIdUrl, new UpdateServerIdRequest(user.getUsername(), user.getUUID(), serverID), null), Void.class);
        return result.isSuccessful();
    }

    @Override
    public User checkServer(Client client, String username, String serverID) throws IOException {
        return this.requester.send(this.requester.post(this.checkServerUrl, new CheckServerRequest(username, serverID), null), HttpUser.class).getOrThrow();
    }

    @Override
    public boolean joinServer(Client client, String username, String accessToken, String serverID) throws IOException {
        HttpHelper.HttpOptional<Void, HttpRequester.SimpleError> result = this.requester.send(this.requester.post(this.joinServerUrl, new JoinServerRequest(username, accessToken, serverID), null), Void.class);
        return result.isSuccessful();
    }

    @Override
    public void init(LaunchServer server) {
        this.requester = new HttpRequester();
        if (this.getUserByUsernameUrl == null) {
            throw new IllegalArgumentException("'getUserByUsernameUrl' can't be null");
        }
        if (this.getUserByUUIDUrl == null) {
            throw new IllegalArgumentException("'getUserByUUIDUrl' can't be null");
        }
        if (this.authorizeUrl == null) {
            throw new IllegalArgumentException("'authorizeUrl' can't be null");
        }
        if (this.checkServerUrl == null && this.joinServerUrl == null && this.updateServerIdUrl == null) {
            throw new IllegalArgumentException("Please set 'checkServerUrl' and 'joinServerUrl' or 'updateServerIdUrl'");
        }
    }

    @Override
    public void close() throws IOException {
    }

    public static class HttpUser
    implements User,
    UserSupportTextures,
    UserSupportProperties {
        private String username;
        private UUID uuid;
        private String serverId;
        private String accessToken;
        private ClientPermissions permissions;
        @Deprecated
        private Texture skin;
        @Deprecated
        private Texture cloak;
        private Map<String, Texture> assets;
        private Map<String, String> properties;

        public HttpUser() {
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, Texture skin, Texture cloak) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.skin = skin;
            this.cloak = cloak;
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, Texture skin, Texture cloak, Map<String, String> properties) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.skin = skin;
            this.cloak = cloak;
            this.properties = properties;
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, Map<String, Texture> assets, Map<String, String> properties) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.assets = assets;
            this.properties = properties;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public ClientPermissions getPermissions() {
            return this.permissions;
        }

        @Override
        public Texture getSkinTexture() {
            if (this.assets == null) {
                return this.skin;
            }
            return this.assets.get("SKIN");
        }

        @Override
        public Texture getCloakTexture() {
            if (this.assets == null) {
                return this.cloak;
            }
            return this.assets.get("CAPE");
        }

        public Map<String, Texture> getAssets() {
            if (this.assets == null) {
                HashMap<String, Texture> map = new HashMap<String, Texture>();
                if (this.skin != null) {
                    map.put("SKIN", this.skin);
                }
                if (this.cloak != null) {
                    map.put("CAPE", this.cloak);
                }
                return map;
            }
            return this.assets;
        }

        @Override
        public Map<String, String> getProperties() {
            if (this.properties == null) {
                return new HashMap<String, String>();
            }
            return this.properties;
        }
    }

    public static class GetAuthDetailsResponse {
        public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> details;
    }

    public static class HttpUserSession
    implements UserSession {
        private String id;
        private HttpUser user;
        private long expireIn;

        public HttpUserSession() {
        }

        public HttpUserSession(String id, HttpUser user, long expireIn) {
            this.id = id;
            this.user = user;
            this.expireIn = expireIn;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public long getExpireIn() {
            return this.expireIn;
        }
    }

    public static class RefreshTokenRequest {
        public String refreshToken;
        public AuthResponse.AuthContext context;

        public RefreshTokenRequest(String refreshToken, AuthResponse.AuthContext context) {
            this.refreshToken = refreshToken;
            this.context = context;
        }
    }

    public static class AuthorizeRequest {
        public String login;
        public AuthResponse.AuthContext context;
        public AuthRequest.AuthPasswordInterface password;
        public boolean minecraftAccess;

        public AuthorizeRequest() {
        }

        public AuthorizeRequest(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) {
            this.login = login;
            this.context = context;
            this.password = password;
            this.minecraftAccess = minecraftAccess;
        }
    }

    public record HttpAuthReport(String minecraftAccessToken, String oauthAccessToken, String oauthRefreshToken, long oauthExpire, HttpUserSession session) {
        public AuthManager.AuthReport toAuthReport() {
            return new AuthManager.AuthReport(this.minecraftAccessToken, this.oauthAccessToken, this.oauthRefreshToken, this.oauthExpire, this.session);
        }
    }

    public static class UpdateServerIdRequest {
        public String username;
        public UUID uuid;
        public String serverId;

        public UpdateServerIdRequest(String username, UUID uuid, String serverId) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
        }
    }

    public static class CheckServerRequest {
        public String username;
        public String serverId;

        public CheckServerRequest(String username, String serverId) {
            this.username = username;
            this.serverId = serverId;
        }
    }

    public static class JoinServerRequest {
        public String username;
        public String accessToken;
        public String serverId;

        public JoinServerRequest(String username, String accessToken, String serverId) {
            this.username = username;
            this.accessToken = accessToken;
            this.serverId = serverId;
        }
    }
}

