/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.PostgreSQLSourceConfig;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.password.PasswordVerifier;
import pro.gravit.launchserver.helper.LegacySessionHelper;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.SecurityHelper;

public class PostgresSQLCoreProvider
extends AuthCoreProvider {
    private final transient Logger logger = LogManager.getLogger();
    public PostgreSQLSourceConfig postgresSQLHolder;
    public int expireSeconds = 3600;
    public String uuidColumn;
    public String usernameColumn;
    public String accessTokenColumn;
    public String passwordColumn;
    public String serverIDColumn;
    public String table;
    public PasswordVerifier passwordVerifier;
    public String customQueryByUUIDSQL;
    public String customQueryByUsernameSQL;
    public String customQueryByLoginSQL;
    public String customUpdateAuthSQL;
    public String customUpdateServerIdSQL;
    private transient String queryByUUIDSQL;
    private transient String queryByUsernameSQL;
    private transient String queryByLoginSQL;
    private transient String updateAuthSQL;
    private transient String updateServerIDSQL;
    private transient LaunchServer server;

    @Override
    public User getUserByUsername(String username) {
        try {
            return this.query(this.queryByUsernameSQL, username);
        }
        catch (IOException e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
    }

    @Override
    public User getUserByUUID(UUID uuid) {
        try {
            return this.query(this.queryByUUIDSQL, uuid.toString());
        }
        catch (IOException e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
    }

    @Override
    public User getUserByLogin(String login) {
        try {
            return this.query(this.queryByLoginSQL, login);
        }
        catch (IOException e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
    }

    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        try {
            LegacySessionHelper.JwtTokenInfo info = LegacySessionHelper.getJwtInfoFromAccessToken(accessToken, this.server.keyAgreementManager.ecdsaPublicKey);
            PostgresSQLUser user = (PostgresSQLUser)this.getUserByUUID(info.uuid());
            if (user == null) {
                return null;
            }
            return new MySQLUserSession(user);
        }
        catch (ExpiredJwtException e) {
            throw new AuthCoreProvider.OAuthAccessTokenExpired();
        }
        catch (JwtException e) {
            return null;
        }
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String refreshToken, AuthResponse.AuthContext context) {
        String[] parts = refreshToken.split("\\.");
        if (parts.length != 2) {
            return null;
        }
        String username = parts[0];
        String token = parts[1];
        PostgresSQLUser user = (PostgresSQLUser)this.getUserByUsername(username);
        if (user == null || user.password == null) {
            return null;
        }
        String realToken = LegacySessionHelper.makeRefreshTokenFromPassword(username, user.password, this.server.keyAgreementManager.legacySalt);
        if (!token.equals(realToken)) {
            return null;
        }
        String accessToken = LegacySessionHelper.makeAccessJwtTokenFromString(user, LocalDateTime.now(Clock.systemUTC()).plusSeconds(this.expireSeconds), this.server.keyAgreementManager.ecdsaPrivateKey);
        return new AuthManager.AuthReport(null, accessToken, refreshToken, (long)this.expireSeconds * 1000L, new MySQLUserSession(user));
    }

    @Override
    public AuthManager.AuthReport authorize(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        PostgresSQLUser postgresSQLUser = (PostgresSQLUser)this.getUserByLogin(login);
        if (postgresSQLUser == null) {
            throw AuthException.wrongPassword();
        }
        if (context != null) {
            AuthPlainPassword plainPassword = (AuthPlainPassword)password;
            if (plainPassword == null) {
                throw AuthException.wrongPassword();
            }
            if (!this.passwordVerifier.check(postgresSQLUser.password, plainPassword.password)) {
                throw AuthException.wrongPassword();
            }
        }
        MySQLUserSession session = new MySQLUserSession(postgresSQLUser);
        String accessToken = LegacySessionHelper.makeAccessJwtTokenFromString(postgresSQLUser, LocalDateTime.now(Clock.systemUTC()).plusSeconds(this.expireSeconds), this.server.keyAgreementManager.ecdsaPrivateKey);
        String refreshToken = postgresSQLUser.username.concat(".").concat(LegacySessionHelper.makeRefreshTokenFromPassword(postgresSQLUser.username, postgresSQLUser.password, this.server.keyAgreementManager.legacySalt));
        if (minecraftAccess) {
            String minecraftAccessToken = SecurityHelper.randomStringToken();
            this.updateAuth(postgresSQLUser, minecraftAccessToken);
            return AuthManager.AuthReport.ofOAuthWithMinecraft(minecraftAccessToken, accessToken, refreshToken, (long)this.expireSeconds * 1000L, session);
        }
        return AuthManager.AuthReport.ofOAuth(accessToken, refreshToken, (long)this.expireSeconds * 1000L, session);
    }

    @Override
    public void init(LaunchServer server) {
        this.server = server;
        if (this.postgresSQLHolder == null) {
            this.logger.error("postgresSQLHolder cannot be null");
        }
        if (this.uuidColumn == null) {
            this.logger.error("uuidColumn cannot be null");
        }
        if (this.usernameColumn == null) {
            this.logger.error("usernameColumn cannot be null");
        }
        if (this.accessTokenColumn == null) {
            this.logger.error("accessTokenColumn cannot be null");
        }
        if (this.serverIDColumn == null) {
            this.logger.error("serverIDColumn cannot be null");
        }
        if (this.table == null) {
            this.logger.error("table cannot be null");
        }
        String userInfoCols = String.format("%s, %s, %s, %s, %s", this.uuidColumn, this.usernameColumn, this.accessTokenColumn, this.serverIDColumn, this.passwordColumn);
        this.queryByUUIDSQL = this.customQueryByUUIDSQL != null ? this.customQueryByUUIDSQL : String.format("SELECT %s FROM %s WHERE %s=? LIMIT 1", userInfoCols, this.table, this.uuidColumn);
        this.queryByUsernameSQL = this.customQueryByUsernameSQL != null ? this.customQueryByUsernameSQL : String.format("SELECT %s FROM %s WHERE %s=? LIMIT 1", userInfoCols, this.table, this.usernameColumn);
        this.queryByLoginSQL = this.customQueryByLoginSQL != null ? this.customQueryByLoginSQL : this.queryByUsernameSQL;
        this.updateAuthSQL = this.customUpdateAuthSQL != null ? this.customUpdateAuthSQL : String.format("UPDATE %s SET %s=?, %s=NULL WHERE %s=?", this.table, this.accessTokenColumn, this.serverIDColumn, this.uuidColumn);
        this.updateServerIDSQL = this.customUpdateServerIdSQL != null ? this.customUpdateServerIdSQL : String.format("UPDATE %s SET %s=? WHERE %s=?", this.table, this.serverIDColumn, this.uuidColumn);
    }

    protected boolean updateAuth(User user, String accessToken) throws IOException {
        boolean bl;
        block8: {
            Connection c = this.postgresSQLHolder.getConnection();
            try {
                PostgresSQLUser postgresSQLUser = (PostgresSQLUser)user;
                postgresSQLUser.accessToken = accessToken;
                PreparedStatement s = c.prepareStatement(this.updateAuthSQL);
                s.setString(1, accessToken);
                s.setString(2, user.getUUID().toString());
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                boolean bl2 = bl = s.executeUpdate() > 0;
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            c.close();
        }
        return bl;
    }

    @Override
    protected boolean updateServerID(User user, String serverID) throws IOException {
        boolean bl;
        block8: {
            Connection c = this.postgresSQLHolder.getConnection();
            try {
                PostgresSQLUser postgresSQLUser = (PostgresSQLUser)user;
                postgresSQLUser.serverId = serverID;
                PreparedStatement s = c.prepareStatement(this.updateServerIDSQL);
                s.setString(1, serverID);
                s.setString(2, user.getUUID().toString());
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                boolean bl2 = bl = s.executeUpdate() > 0;
                if (c == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (c != null) {
                        try {
                            c.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new IOException(e);
                }
            }
            c.close();
        }
        return bl;
    }

    @Override
    public void close() throws IOException {
        this.postgresSQLHolder.close();
    }

    private PostgresSQLUser constructUser(ResultSet set) throws SQLException {
        return set.next() ? new PostgresSQLUser(UUID.fromString(set.getString(this.uuidColumn)), set.getString(this.usernameColumn), set.getString(this.accessTokenColumn), set.getString(this.serverIDColumn), set.getString(this.passwordColumn), new ClientPermissions()) : null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private User query(String sql, String value) throws IOException {
        try (Connection c = this.postgresSQLHolder.getConnection();){
            PostgresSQLUser postgresSQLUser;
            block14: {
                PreparedStatement s = c.prepareStatement(sql);
                s.setString(1, value);
                s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
                ResultSet set = s.executeQuery();
                try {
                    postgresSQLUser = this.constructUser(set);
                    if (set == null) break block14;
                }
                catch (Throwable throwable) {
                    if (set != null) {
                        try {
                            set.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                set.close();
            }
            return postgresSQLUser;
        }
        catch (SQLException e) {
            throw new IOException(e);
        }
    }

    public static class PostgresSQLUser
    implements User {
        protected UUID uuid;
        protected String username;
        protected String accessToken;
        protected String serverId;
        protected String password;
        protected ClientPermissions permissions;

        public PostgresSQLUser(UUID uuid, String username, String accessToken, String serverId, String password, ClientPermissions permissions) {
            this.uuid = uuid;
            this.username = username;
            this.accessToken = accessToken;
            this.serverId = serverId;
            this.password = password;
            this.permissions = permissions;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public ClientPermissions getPermissions() {
            return this.permissions;
        }

        public String toString() {
            return "PostgresSQLUser{uuid=" + this.uuid + ", username='" + this.username + "', permissions=" + this.permissions + "}";
        }
    }

    public static class MySQLUserSession
    implements UserSession {
        private final PostgresSQLUser user;
        private final String id;

        public MySQLUserSession(PostgresSQLUser user) {
            this.user = user;
            this.id = user.username;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public long getExpireIn() {
            return 0L;
        }
    }
}

