/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.command.CommandHandler;
import pro.gravit.utils.helper.JVMHelper;

public class ServerStatusCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public ServerStatusCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "Check server status";
    }

    public void invoke(String ... args) {
        this.logger.info("Show server status");
        this.logger.info("Memory: free {} | total: {} | max: {}", (Object)JVMHelper.RUNTIME.freeMemory(), (Object)JVMHelper.RUNTIME.totalMemory(), (Object)JVMHelper.RUNTIME.maxMemory());
        long uptime = JVMHelper.RUNTIME_MXBEAN.getUptime() / 1000L;
        long second = uptime % 60L;
        long min = uptime / 60L % 60L;
        long hour = uptime / 60L / 60L % 24L;
        long days = uptime / 60L / 60L / 24L;
        this.logger.info("Uptime: {} days {} hours {} minutes {} seconds", (Object)days, (Object)hour, (Object)min, (Object)second);
        this.logger.info("Uptime (double): {}", (Object)((double)JVMHelper.RUNTIME_MXBEAN.getUptime() / 1000.0));
        int commands = this.server.commandHandler.getBaseCategory().commandsMap().size();
        for (CommandHandler.Category category : this.server.commandHandler.getCategories()) {
            commands += category.category.commandsMap().size();
        }
        this.logger.info("Commands: {}({} categories)", (Object)commands, (Object)(this.server.commandHandler.getCategories().size() + 1));
        for (AuthProviderPair authProviderPair : this.server.config.auth.values()) {
        }
    }
}

