/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.io.IOException;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.HttpRequester;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.UserHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportProperties;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportTextures;
import pro.gravit.launchserver.helper.HttpHelper;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.CommonHelper;

public class HttpAuthCoreProvider
extends AuthCoreProvider
implements AuthSupportHardware {
    private final transient Logger logger = LogManager.getLogger();
    private transient HttpRequester requester;
    public String bearerToken;
    public String getUserByUsernameUrl;
    public String getUserByLoginUrl;
    public String getUserByUUIDUrl;
    public String getUserByTokenUrl;
    public String getAuthDetailsUrl;
    public String refreshTokenUrl;
    public String authorizeUrl;
    public String joinServerUrl;
    public String checkServerUrl;
    public String updateServerIdUrl;
    public String getHardwareInfoByPublicKeyUrl;
    public String getHardwareInfoByDataUrl;
    public String getHardwareInfoByIdUrl;
    public String createHardwareInfoUrl;
    public String connectUserAndHardwareUrl;
    public String addPublicKeyToHardwareInfoUrl;
    public String getUsersByHardwareInfoUrl;
    public String banHardwareUrl;
    public String unbanHardwareUrl;

    @Override
    public User getUserByUsername(String username) {
        try {
            return this.requester.send(this.requester.get(CommonHelper.replace((String)this.getUserByUsernameUrl, (String[])new String[]{"username", username}), null), HttpUser.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public User getUserByLogin(String login) {
        if (this.getUserByLoginUrl != null) {
            try {
                return this.requester.send(this.requester.get(CommonHelper.replace((String)this.getUserByLoginUrl, (String[])new String[]{"login", login}), null), HttpUser.class).getOrThrow();
            }
            catch (IOException e) {
                this.logger.error((Object)e);
                return null;
            }
        }
        return super.getUserByLogin(login);
    }

    @Override
    public User getUserByUUID(UUID uuid) {
        try {
            return this.requester.send(this.requester.get(CommonHelper.replace((String)this.getUserByUUIDUrl, (String[])new String[]{"uuid", uuid.toString()}), null), HttpUser.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        if (this.getAuthDetailsUrl == null) {
            return super.getDetails(client);
        }
        try {
            GetAuthDetailsResponse result = this.requester.send(this.requester.get(this.getAuthDetailsUrl, this.bearerToken), GetAuthDetailsResponse.class).getOrThrow();
            return result.details;
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return super.getDetails(client);
        }
    }

    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        if (this.getUserByTokenUrl == null) {
            return null;
        }
        try {
            HttpHelper.HttpOptional<HttpUserSession, HttpRequester.SimpleError> result = this.requester.send(this.requester.get(this.getUserByTokenUrl, accessToken), HttpUserSession.class);
            if (!result.isSuccessful()) {
                String error = result.error().error;
                if (error.equals("auth.expiretoken")) {
                    throw new AuthCoreProvider.OAuthAccessTokenExpired();
                }
                return null;
            }
            return result.getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String refreshToken, AuthResponse.AuthContext context) {
        if (this.refreshTokenUrl == null) {
            return null;
        }
        try {
            return this.requester.send(this.requester.post(this.refreshTokenUrl, new RefreshTokenRequest(refreshToken, context), null), HttpAuthReport.class).getOrThrow().toAuthReport();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public AuthManager.AuthReport authorize(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        String error;
        HttpHelper.HttpOptional<HttpAuthReport, HttpRequester.SimpleError> result = this.requester.send(this.requester.post(this.authorizeUrl, new AuthorizeRequest(login, context, password, minecraftAccess), this.bearerToken), HttpAuthReport.class);
        if (!result.isSuccessful() && (error = result.error().error) != null) {
            throw new AuthException(error);
        }
        return result.getOrThrow().toAuthReport();
    }

    @Override
    public UserHardware getHardwareInfoByPublicKey(byte[] publicKey) {
        if (this.getHardwareInfoByPublicKeyUrl == null) {
            return null;
        }
        try {
            return this.requester.send(this.requester.post(this.getHardwareInfoByPublicKeyUrl, new HardwareRequest(publicKey), this.bearerToken), HttpUserHardware.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public UserHardware getHardwareInfoByData(HardwareReportRequest.HardwareInfo info) {
        if (this.getHardwareInfoByDataUrl == null) {
            return null;
        }
        try {
            HardwareRequest request = new HardwareRequest(new HttpUserHardware(info));
            HttpHelper.HttpOptional<HttpUserHardware, HttpRequester.SimpleError> hardware = this.requester.send(this.requester.post(this.getHardwareInfoByDataUrl, request, this.bearerToken), HttpUserHardware.class);
            return hardware.isSuccessful() ? (UserHardware)hardware.getOrThrow() : null;
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public UserHardware getHardwareInfoById(String id) {
        if (this.getHardwareInfoByIdUrl == null) {
            return null;
        }
        try {
            return this.requester.send(this.requester.post(this.getHardwareInfoByIdUrl, new HardwareRequest(new HttpUserHardware(Long.parseLong(id))), this.bearerToken), HttpUserHardware.class).getOrThrow();
        }
        catch (IOException | NumberFormatException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public UserHardware createHardwareInfo(HardwareReportRequest.HardwareInfo info, byte[] publicKey) {
        if (this.createHardwareInfoUrl == null) {
            return null;
        }
        try {
            return this.requester.send(this.requester.post(this.createHardwareInfoUrl, new HardwareRequest(new HttpUserHardware(info, publicKey, false)), this.bearerToken), HttpUserHardware.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public void connectUserAndHardware(UserSession userSession, UserHardware hardware) {
        if (this.connectUserAndHardwareUrl == null) {
            return;
        }
        try {
            this.requester.send(this.requester.post(this.connectUserAndHardwareUrl, new HardwareRequest((HttpUserHardware)hardware, (HttpUserSession)userSession), this.bearerToken), Void.class);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public void addPublicKeyToHardwareInfo(UserHardware hardware, byte[] publicKey) {
        if (this.addPublicKeyToHardwareInfoUrl == null) {
            return;
        }
        try {
            this.requester.send(this.requester.post(this.addPublicKeyToHardwareInfoUrl, new HardwareRequest((HttpUserHardware)hardware, publicKey), this.bearerToken), Void.class);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public Iterable<User> getUsersByHardwareInfo(UserHardware hardware) {
        if (this.getUsersByHardwareInfoUrl == null) {
            return null;
        }
        try {
            return this.requester.send(this.requester.post(this.getUsersByHardwareInfoUrl, new HardwareRequest((HttpUserHardware)hardware), this.bearerToken), List.class).getOrThrow();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
            return null;
        }
    }

    @Override
    public void banHardware(UserHardware hardware) {
        if (this.banHardwareUrl == null) {
            return;
        }
        try {
            this.requester.send(this.requester.post(this.banHardwareUrl, new HardwareRequest((HttpUserHardware)hardware), this.bearerToken), Void.class);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    public void unbanHardware(UserHardware hardware) {
        if (this.unbanHardwareUrl == null) {
            return;
        }
        try {
            this.requester.send(this.requester.post(this.unbanHardwareUrl, new HardwareRequest((HttpUserHardware)hardware), this.bearerToken), Void.class);
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    @Override
    protected boolean updateServerID(User user, String serverID) throws IOException {
        HttpHelper.HttpOptional<Void, HttpRequester.SimpleError> result = this.requester.send(this.requester.post(this.updateServerIdUrl, new UpdateServerIdRequest(user.getUsername(), user.getUUID(), serverID), null), Void.class);
        return result.isSuccessful();
    }

    @Override
    public User checkServer(Client client, String username, String serverID) throws IOException {
        return this.requester.send(this.requester.post(this.checkServerUrl, new CheckServerRequest(username, serverID), this.bearerToken), HttpUser.class).getOrThrow();
    }

    @Override
    public boolean joinServer(Client client, String username, String accessToken, String serverID) throws IOException {
        HttpHelper.HttpOptional<Void, HttpRequester.SimpleError> result = this.requester.send(this.requester.post(this.joinServerUrl, new JoinServerRequest(username, accessToken, serverID), this.bearerToken), Void.class);
        return result.isSuccessful();
    }

    @Override
    public void init(LaunchServer server) {
        this.requester = new HttpRequester();
        if (this.getUserByUsernameUrl == null) {
            throw new IllegalArgumentException("'getUserByUsernameUrl' can't be null");
        }
        if (this.getUserByUUIDUrl == null) {
            throw new IllegalArgumentException("'getUserByUUIDUrl' can't be null");
        }
        if (this.authorizeUrl == null) {
            throw new IllegalArgumentException("'authorizeUrl' can't be null");
        }
        if (this.checkServerUrl == null && this.joinServerUrl == null && this.updateServerIdUrl == null) {
            throw new IllegalArgumentException("Please set 'checkServerUrl' and 'joinServerUrl' or 'updateServerIdUrl'");
        }
    }

    @Override
    public void close() throws IOException {
    }

    public class HttpUser
    implements User,
    UserSupportTextures,
    UserSupportProperties,
    UserSupportHardware {
        private String username;
        private UUID uuid;
        private String serverId;
        private String accessToken;
        private ClientPermissions permissions;
        @Deprecated
        private Texture skin;
        @Deprecated
        private Texture cloak;
        private Map<String, Texture> assets;
        private Map<String, String> properties;
        private long hwidId;
        private transient HttpUserHardware hardware;

        public HttpUser() {
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, long hwidId) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.hwidId = hwidId;
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, Texture skin, Texture cloak, long hwidId) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.skin = skin;
            this.cloak = cloak;
            this.hwidId = hwidId;
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, Texture skin, Texture cloak, Map<String, String> properties, long hwidId) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.skin = skin;
            this.cloak = cloak;
            this.properties = properties;
            this.hwidId = hwidId;
        }

        public HttpUser(String username, UUID uuid, String serverId, String accessToken, ClientPermissions permissions, Map<String, Texture> assets, Map<String, String> properties, long hwidId) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
            this.accessToken = accessToken;
            this.permissions = permissions;
            this.assets = assets;
            this.properties = properties;
            this.hwidId = hwidId;
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public String getServerId() {
            return this.serverId;
        }

        @Override
        public String getAccessToken() {
            return this.accessToken;
        }

        @Override
        public ClientPermissions getPermissions() {
            return this.permissions;
        }

        @Override
        public Texture getSkinTexture() {
            if (this.assets == null) {
                return this.skin;
            }
            return this.assets.get("SKIN");
        }

        @Override
        public Texture getCloakTexture() {
            if (this.assets == null) {
                return this.cloak;
            }
            return this.assets.get("CAPE");
        }

        public Map<String, Texture> getAssets() {
            if (this.assets == null) {
                HashMap<String, Texture> map = new HashMap<String, Texture>();
                if (this.skin != null) {
                    map.put("SKIN", this.skin);
                }
                if (this.cloak != null) {
                    map.put("CAPE", this.cloak);
                }
                return map;
            }
            return this.assets;
        }

        @Override
        public Map<String, String> getProperties() {
            if (this.properties == null) {
                return new HashMap<String, String>();
            }
            return this.properties;
        }

        public String toString() {
            return "HttpUser{username='" + this.username + "', uuid=" + this.uuid + ", serverId='" + this.serverId + "', accessToken='" + this.accessToken + "', permissions=" + this.permissions + ", assets=" + this.getAssets() + ", properties=" + this.properties + ", hwidId=" + this.hwidId + "}";
        }

        @Override
        public UserHardware getHardware() {
            HttpUserHardware result;
            if (this.hardware != null) {
                return this.hardware;
            }
            this.hardware = result = (HttpUserHardware)HttpAuthCoreProvider.this.getHardwareInfoById(String.valueOf(this.hwidId));
            return result;
        }
    }

    public static class GetAuthDetailsResponse {
        public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> details;
    }

    public static class HttpUserSession
    implements UserSession {
        private String id;
        private HttpUser user;
        private long expireIn;

        public HttpUserSession() {
        }

        public HttpUserSession(String id, HttpUser user, long expireIn) {
            this.id = id;
            this.user = user;
            this.expireIn = expireIn;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public long getExpireIn() {
            return this.expireIn;
        }

        public String toString() {
            return "HttpUserSession{id='" + this.id + "', user=" + this.user + ", expireIn=" + this.expireIn + "}";
        }
    }

    public static class RefreshTokenRequest {
        public String refreshToken;
        public AuthResponse.AuthContext context;

        public RefreshTokenRequest(String refreshToken, AuthResponse.AuthContext context) {
            this.refreshToken = refreshToken;
            this.context = context;
        }
    }

    public record HttpAuthReport(String minecraftAccessToken, String oauthAccessToken, String oauthRefreshToken, long oauthExpire, HttpUserSession session) {
        public AuthManager.AuthReport toAuthReport() {
            return new AuthManager.AuthReport(this.minecraftAccessToken, this.oauthAccessToken, this.oauthRefreshToken, this.oauthExpire, this.session);
        }
    }

    public static class AuthorizeRequest {
        public String login;
        public AuthResponse.AuthContext context;
        public AuthRequest.AuthPasswordInterface password;
        public boolean minecraftAccess;

        public AuthorizeRequest() {
        }

        public AuthorizeRequest(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) {
            this.login = login;
            this.context = context;
            this.password = password;
            this.minecraftAccess = minecraftAccess;
        }
    }

    public record HardwareRequest(HttpUserHardware userHardware, byte[] key, HttpUserSession userSession) {
        public HardwareRequest(HttpUserHardware userHardware) {
            this(userHardware, null, null);
        }

        public HardwareRequest(HttpUserHardware userHardware, byte[] key) {
            this(userHardware, key, null);
        }

        public HardwareRequest(HttpUserHardware userHardware, HttpUserSession userSession) {
            this(userHardware, null, userSession);
        }

        public HardwareRequest(byte[] key) {
            this(null, key, null);
        }
    }

    public static class HttpUserHardware
    implements UserHardware {
        private final HardwareReportRequest.HardwareInfo hardwareInfo;
        private final long id;
        private byte[] publicKey;
        private boolean banned;

        public HttpUserHardware(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, long id, boolean banned) {
            this.hardwareInfo = hardwareInfo;
            this.publicKey = publicKey;
            this.id = id;
            this.banned = banned;
        }

        public HttpUserHardware(HardwareReportRequest.HardwareInfo hardwareInfo) {
            this.hardwareInfo = hardwareInfo;
            this.id = Long.MIN_VALUE;
        }

        public HttpUserHardware(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, boolean banned) {
            this.hardwareInfo = hardwareInfo;
            this.publicKey = publicKey;
            this.banned = banned;
            this.id = Long.MIN_VALUE;
        }

        public HttpUserHardware(long id) {
            this.id = id;
            this.hardwareInfo = null;
        }

        @Override
        public HardwareReportRequest.HardwareInfo getHardwareInfo() {
            return this.hardwareInfo;
        }

        @Override
        public byte[] getPublicKey() {
            return this.publicKey;
        }

        @Override
        public String getId() {
            return String.valueOf(this.id);
        }

        @Override
        public boolean isBanned() {
            return this.banned;
        }

        public String toString() {
            return "HttpUserHardware{hardwareInfo=" + this.hardwareInfo + ", publicKey=" + (this.publicKey == null ? null : new String(Base64.getEncoder().encode(this.publicKey))) + ", id=" + this.id + ", banned=" + this.banned + "}";
        }
    }

    public static class UpdateServerIdRequest {
        public String username;
        public UUID uuid;
        public String serverId;

        public UpdateServerIdRequest(String username, UUID uuid, String serverId) {
            this.username = username;
            this.uuid = uuid;
            this.serverId = serverId;
        }
    }

    public static class CheckServerRequest {
        public String username;
        public String serverId;

        public CheckServerRequest(String username, String serverId) {
            this.username = username;
            this.serverId = serverId;
        }
    }

    public static class JoinServerRequest {
        public String username;
        public String accessToken;
        public String serverId;

        public JoinServerRequest(String username, String accessToken, String serverId) {
            this.username = username;
            this.accessToken = accessToken;
            this.serverId = serverId;
        }
    }
}

