/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks.exe;

import java.io.IOException;
import java.nio.file.Path;
import net.sf.launch4j.Builder;
import net.sf.launch4j.Log;
import net.sf.launch4j.config.Config;
import net.sf.launch4j.config.ConfigPersister;
import net.sf.launch4j.config.Jre;
import net.sf.launch4j.config.LanguageID;
import net.sf.launch4j.config.VersionInfo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.launchserver.binary.tasks.exe.BuildExeMainTask;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.IOHelper;

public class Launch4JTask
implements LauncherBuildTask,
BuildExeMainTask {
    public static final String DOWNLOAD_URL = "https://bell-sw.com/pages/downloads/?version=java-8-lts&os=Windows&package=jre-full";
    private static final String VERSION = Version.getVersion().getVersionString();
    private static final int BUILD = Version.getVersion().build;
    private final Path faviconFile;
    private final LaunchServer server;
    private final transient Logger logger = LogManager.getLogger();

    public Launch4JTask(LaunchServer launchServer) {
        this.server = launchServer;
        this.faviconFile = launchServer.dir.resolve("favicon.ico");
    }

    public static String formatVars(String mask) {
        return String.format(mask, VERSION, BUILD);
    }

    @Override
    public String getName() {
        return "launch4j";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        this.logger.info("Building launcher EXE binary file (Using Launch4J)");
        Path output = this.setConfig();
        Config config = ConfigPersister.getInstance().getConfig();
        if (IOHelper.isFile((Path)this.faviconFile)) {
            config.setIcon(this.faviconFile.toFile());
        } else {
            config.setIcon(null);
            this.logger.warn("Missing favicon.ico file");
        }
        Builder builder = new Builder((Log)Launch4JLog.INSTANCE);
        try {
            builder.build();
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
        return output;
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    private Path setConfig() {
        Path path = this.server.launcherEXEBinary.nextPath(this.getName());
        Config config = new Config();
        config.setChdir(".");
        config.setErrTitle("JVM Error");
        config.setDownloadUrl(this.server.config.launch4j.downloadUrl);
        if (this.server.config.launch4j.supportURL != null) {
            config.setSupportUrl(this.server.config.launch4j.supportURL);
        }
        config.setPriorityIndex(0);
        config.setHeaderType("gui");
        config.setStayAlive(false);
        config.setRestartOnCrash(false);
        Jre jre = new Jre();
        jre.setMinVersion(this.server.config.launch4j.minVersion);
        if (this.server.config.launch4j.setMaxVersion) {
            jre.setMaxVersion(this.server.config.launch4j.maxVersion);
        }
        jre.setRuntimeBits("64/32");
        jre.setJdkPreference("preferJre");
        config.setJre(jre);
        VersionInfo info = new VersionInfo();
        info.setProductName(this.server.config.launch4j.productName);
        info.setProductVersion(Launch4JTask.formatVars(this.server.config.launch4j.productVer));
        info.setFileDescription(this.server.config.launch4j.fileDesc);
        info.setFileVersion(Launch4JTask.formatVars(this.server.config.launch4j.fileVer));
        info.setCopyright(this.server.config.launch4j.copyright);
        info.setTrademarks(this.server.config.launch4j.trademarks);
        info.setInternalName(Launch4JTask.formatVars(this.server.config.launch4j.internalName));
        info.setTxtFileVersion(Launch4JTask.formatVars(this.server.config.launch4j.txtFileVersion));
        info.setTxtProductVersion(Launch4JTask.formatVars(this.server.config.launch4j.txtProductVersion));
        info.setOriginalFilename(path.getFileName().toString());
        info.setLanguage(LanguageID.RUSSIAN);
        config.setVersionInfo(info);
        config.setDontWrapJar(false);
        config.setJar(this.server.launcherBinary.syncBinaryFile.toFile());
        config.setOutfile(path.toFile());
        ConfigPersister.getInstance().setAntConfig(config, null);
        return path;
    }

    private static final class Launch4JLog
    extends Log {
        private static final Launch4JLog INSTANCE = new Launch4JLog();
        private static final Logger logger = LogManager.getLogger();

        private Launch4JLog() {
        }

        public void append(String s) {
            logger.info(s);
        }

        public void clear() {
        }
    }
}

