/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.launchermodules;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.asm.InjectClassAcceptor;
import pro.gravit.launchserver.binary.tasks.MainBuildTask;
import pro.gravit.launchserver.launchermodules.LauncherModuleClassLoader;
import pro.gravit.launchserver.launchermodules.SyncLauncherModulesCommand;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.IOHelper;

public class LauncherModuleLoader {
    public final List<ModuleEntity> launcherModules = new ArrayList<ModuleEntity>();
    public final Path modulesDir;
    private final LaunchServer server;
    private final transient Logger logger = LogManager.getLogger();

    public LauncherModuleLoader(LaunchServer server) {
        this.server = server;
        this.modulesDir = server.dir.resolve("launcher-modules");
    }

    public void init() {
        if (!IOHelper.isDir((Path)this.modulesDir)) {
            try {
                Files.createDirectories(this.modulesDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                this.logger.error((Object)e);
            }
        }
        this.server.commandHandler.registerCommand("syncLauncherModules", (Command)new SyncLauncherModulesCommand(this));
        MainBuildTask mainTask = this.server.launcherBinary.getTaskByClass(MainBuildTask.class).get();
        mainTask.preBuildHook.registerHook(buildContext -> {
            for (ModuleEntity e : this.launcherModules) {
                if (e.propertyMap != null) {
                    buildContext.task.properties.putAll(e.propertyMap);
                }
                buildContext.clientModules.add(e.moduleMainClass);
                buildContext.readerClassPath.add(new JarFile(e.path.toFile()));
            }
        });
        mainTask.postBuildHook.registerHook(buildContext -> {
            for (ModuleEntity e : this.launcherModules) {
                this.logger.debug("Put {} launcher module", (Object)e.path.toString());
                buildContext.pushJarFile(e.path, en -> false, en -> true);
            }
        });
        try {
            this.syncModules();
        }
        catch (IOException e) {
            this.logger.error((Object)e);
        }
    }

    public void syncModules() throws IOException {
        this.launcherModules.clear();
        IOHelper.walk((Path)this.modulesDir, (FileVisitor)new ModulesVisitor(), (boolean)false);
    }

    public void addClassFieldsToProperties(Map<String, Object> propertyMap, String prefix, Object object, Class<?> classOfObject) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = classOfObject.getFields()) {
            if ((field.getModifiers() & 8) != 0) continue;
            Object obj = field.get(object);
            String propertyName = prefix.concat(".").concat(field.getName().toLowerCase(Locale.US));
            if (InjectClassAcceptor.isSerializableValue(obj)) {
                this.logger.trace("Property name {}", (Object)propertyName);
                propertyMap.put(propertyName, obj);
                continue;
            }
            this.addClassFieldsToProperties(propertyMap, propertyName, obj, obj.getClass());
        }
    }

    protected final class ModulesVisitor
    extends SimpleFileVisitor<Path> {
        private LauncherModuleClassLoader classLoader;

        private ModulesVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            block33: {
                if (file.toFile().getName().endsWith(".jar")) {
                    try (JarFile f = new JarFile(file.toFile());){
                        Attributes attributes = f.getManifest().getMainAttributes();
                        String mainClass = attributes.getValue("Module-Main-Class");
                        if (mainClass == null) {
                            LauncherModuleLoader.this.logger.error("In module {} MainClass not found", (Object)file.toString());
                            break block33;
                        }
                        if (this.classLoader == null) {
                            this.classLoader = new LauncherModuleClassLoader(LauncherModuleLoader.this.server.modulesManager.getModuleClassLoader());
                        }
                        this.classLoader.addURL(file.toUri().toURL());
                        ModuleEntity entity = new ModuleEntity();
                        entity.path = file;
                        entity.moduleMainClass = mainClass;
                        try {
                            Class<?> mainClazz = this.classLoader.loadClass(entity.moduleMainClass);
                            entity.checkResult = LauncherModuleLoader.this.server.modulesManager.checkModuleClass(mainClazz);
                        }
                        catch (Throwable e) {
                            if (e instanceof ClassNotFoundException || e instanceof NoClassDefFoundError) {
                                LauncherModuleLoader.this.logger.error("Module-MainClass in module {} incorrect", (Object)file.toString());
                            } else {
                                LauncherModuleLoader.this.logger.error((Object)e);
                            }
                            FileVisitResult fileVisitResult = super.visitFile(file, attrs);
                            f.close();
                            return fileVisitResult;
                        }
                        entity.moduleConfigClass = attributes.getValue("Module-Config-Class");
                        if (entity.moduleConfigClass != null) {
                            entity.moduleConfigName = attributes.getValue("Module-Config-Name");
                            if (entity.moduleConfigName == null) {
                                LauncherModuleLoader.this.logger.warn("Module-Config-Name in module {} null. Module not configured", (Object)file.toString());
                            } else {
                                try {
                                    Object targetConfig;
                                    Class<?> clazz = this.classLoader.loadClass(entity.moduleConfigClass);
                                    Path configPath = LauncherModuleLoader.this.server.modulesManager.getConfigManager().getModuleConfig(entity.moduleConfigName);
                                    Object defaultConfig = MethodHandles.publicLookup().findStatic(clazz, "getDefault", MethodType.methodType(Object.class)).invoke();
                                    if (!Files.exists(configPath, new LinkOption[0])) {
                                        LauncherModuleLoader.this.logger.debug("Write default config for module {} to {}", (Object)file.toString(), (Object)configPath.toString());
                                        try (BufferedWriter writer = IOHelper.newWriter((Path)configPath);){
                                            Launcher.gsonManager.configGson.toJson(defaultConfig, (Appendable)writer);
                                        }
                                        targetConfig = defaultConfig;
                                    } else {
                                        try (BufferedReader reader = IOHelper.newReader((Path)configPath);){
                                            targetConfig = Launcher.gsonManager.configGson.fromJson((Reader)reader, clazz);
                                        }
                                    }
                                    if (entity.propertyMap == null) {
                                        entity.propertyMap = new HashMap<String, Object>();
                                    }
                                    LauncherModuleLoader.this.addClassFieldsToProperties(entity.propertyMap, "modules.".concat(entity.moduleConfigName.toLowerCase()), targetConfig, clazz);
                                }
                                catch (Throwable e) {
                                    LauncherModuleLoader.this.logger.error((Object)e);
                                }
                            }
                        }
                        LauncherModuleLoader.this.launcherModules.add(entity);
                    }
                }
            }
            return super.visitFile(file, attrs);
        }
    }

    public static class ModuleEntity {
        public Path path;
        public LauncherTrustManager.CheckClassResult checkResult;
        public String moduleMainClass;
        public String moduleConfigClass;
        public String moduleConfigName;
        public Map<String, Object> propertyMap;
    }
}

