/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.password;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.auth.password.PasswordVerifier;

public class JsonPasswordVerifier
extends PasswordVerifier {
    private static final transient Logger logger = LogManager.getLogger();
    private final transient HttpClient client = HttpClient.newBuilder().build();
    public String url;
    public String bearerToken;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T, R> R jsonRequest(T request, String url, String bearerToken, Class<R> clazz, HttpClient client) {
        HttpRequest.BodyPublisher publisher = request != null ? HttpRequest.BodyPublishers.ofString(Launcher.gsonManager.gson.toJson(request)) : HttpRequest.BodyPublishers.noBody();
        try {
            HttpResponse<InputStream> response;
            int statusCode;
            HttpRequest.Builder request1 = HttpRequest.newBuilder().method("POST", publisher).uri(new URI(url)).header("Content-Type", "application/json; charset=UTF-8").header("Accept", "application/json").timeout(Duration.ofMillis(10000L));
            if (bearerToken != null) {
                request1.header("Authorization", "Bearer ".concat(bearerToken));
            }
            if (200 > (statusCode = (response = client.send(request1.build(), HttpResponse.BodyHandlers.ofInputStream())).statusCode()) || statusCode > 300) {
                if (statusCode >= 500) {
                    logger.error("JsonCoreProvider: {} return {}", (Object)url, (Object)statusCode);
                    return null;
                }
                if (statusCode >= 300 && statusCode <= 400) {
                    logger.error("JsonCoreProvider: {} return {}, try redirect to {}. Redirects not supported!", (Object)url, (Object)statusCode, (Object)response.headers().firstValue("Location").orElse("Unknown"));
                    return null;
                }
                if (statusCode != 403) {
                    if (statusCode != 401) return null;
                }
                logger.error("JsonCoreProvider: {} return {}. Please set 'bearerToken'!", (Object)url, (Object)statusCode);
                return null;
            }
            try (InputStreamReader reader = new InputStreamReader(response.body());){
                Object object = Launcher.gsonManager.gson.fromJson((Reader)reader, clazz);
                return (R)object;
            }
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean check(String encryptedPassword, String password) {
        JsonPasswordResponse response = JsonPasswordVerifier.jsonRequest(new JsonPasswordRequest(encryptedPassword, password), this.url, this.bearerToken, JsonPasswordResponse.class, this.client);
        if (response != null) {
            return response.success;
        }
        return false;
    }

    public static class JsonPasswordRequest {
        public String encryptedPassword;
        public String password;

        public JsonPasswordRequest(String encryptedPassword, String password) {
            this.encryptedPassword = encryptedPassword;
            this.password = password;
        }
    }

    public static class JsonPasswordResponse {
        public boolean success;
    }
}

