/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.binary.tasks;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.binary.tasks.AdditionalFixesApplyTask;
import pro.gravit.launchserver.binary.tasks.LauncherBuildTask;
import pro.gravit.utils.helper.IOHelper;

public class AttachJarsTask
implements LauncherBuildTask {
    private final LaunchServer srv;
    private final List<Path> jars;
    private final List<String> exclusions;

    public AttachJarsTask(LaunchServer srv) {
        this.srv = srv;
        this.jars = new ArrayList<Path>();
        this.exclusions = new ArrayList<String>();
        this.exclusions.add("META-INF");
        this.exclusions.add("module-info.class");
        this.exclusions.add("LICENSE");
        this.exclusions.add("LICENSE.txt");
    }

    @Override
    public String getName() {
        return "AttachJars";
    }

    @Override
    public Path process(Path inputFile) throws IOException {
        Path outputFile = this.srv.launcherBinary.nextPath("attached");
        try (ZipInputStream input = IOHelper.newZipInput((Path)inputFile);
             ZipOutputStream output = new ZipOutputStream(IOHelper.newOutput((Path)outputFile));){
            ZipEntry e = input.getNextEntry();
            while (e != null) {
                if (e.isDirectory()) {
                    e = input.getNextEntry();
                    continue;
                }
                output.putNextEntry(IOHelper.newZipEntry((ZipEntry)e));
                IOHelper.transfer((InputStream)input, (OutputStream)output);
                e = input.getNextEntry();
            }
            this.attach(output, inputFile, this.srv.launcherBinary.coreLibs);
            this.attach(output, inputFile, this.jars);
            for (Map.Entry<String, Path> entry : this.srv.launcherBinary.files.entrySet()) {
                ZipEntry newEntry = IOHelper.newZipEntry((String)entry.getKey());
                output.putNextEntry(newEntry);
                IOHelper.transfer((Path)entry.getValue(), (OutputStream)output);
            }
        }
        return outputFile;
    }

    private void attach(ZipOutputStream output, Path inputFile, List<Path> lst) throws IOException {
        for (Path p : lst) {
            AdditionalFixesApplyTask.apply(inputFile, p, output, this.srv, e -> this.filter(e.getName()), false);
        }
    }

    private boolean filter(String name) {
        if (name.startsWith("META-INF/services")) {
            return false;
        }
        return this.exclusions.stream().anyMatch(name::startsWith);
    }

    @Override
    public boolean allowDelete() {
        return true;
    }

    public List<Path> getJars() {
        return this.jars;
    }

    public List<String> getExclusions() {
        return this.exclusions;
    }
}

