/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.service;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.PosixFilePermission;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.protect.AdvancedProtectHandler;
import pro.gravit.launchserver.auth.protect.NoProtectHandler;
import pro.gravit.launchserver.auth.protect.StdProtectHandler;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.components.ProGuardComponent;
import pro.gravit.launchserver.config.LaunchServerConfig;
import pro.gravit.launchserver.helper.SignHelper;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;

public class SecurityCheckCommand
extends Command {
    private static final transient Logger logger = LogManager.getLogger();

    public SecurityCheckCommand(LaunchServer server) {
        super(server);
    }

    public static void printCheckResult(String module, String comment, Boolean status) {
        if (status == null) {
            logger.warn(String.format("[%s] %s", module, comment));
        } else if (status.booleanValue()) {
            logger.info(String.format("[%s] %s OK", module, comment));
        } else {
            logger.error(String.format("[%s] %s", module, comment));
        }
    }

    public String getArgsDescription() {
        return "[]";
    }

    public String getUsageDescription() {
        return "check configuration";
    }

    public void invoke(String ... args) {
        LaunchServerConfig config = this.server.config;
        config.auth.forEach((name, pair) -> {});
        if (config.protectHandler instanceof NoProtectHandler) {
            SecurityCheckCommand.printCheckResult("protectHandler", "protectHandler none", false);
        } else if (config.protectHandler instanceof AdvancedProtectHandler) {
            SecurityCheckCommand.printCheckResult("protectHandler", "", true);
            if (!((AdvancedProtectHandler)config.protectHandler).enableHardwareFeature) {
                SecurityCheckCommand.printCheckResult("protectHandler.hardwareId", "you can improve security by using hwid provider", null);
            } else {
                SecurityCheckCommand.printCheckResult("protectHandler.hardwareId", "", true);
            }
        } else if (config.protectHandler instanceof StdProtectHandler) {
            SecurityCheckCommand.printCheckResult("protectHandler", "you can improve security by using advanced", null);
        } else {
            SecurityCheckCommand.printCheckResult("protectHandler", "unknown protectHandler", null);
        }
        if (config.netty.address.startsWith("ws://")) {
            if (config.netty.ipForwarding) {
                SecurityCheckCommand.printCheckResult("netty.ipForwarding", "ipForwarding may be used to spoofing ip", null);
            }
            SecurityCheckCommand.printCheckResult("netty.address", "websocket connection not secure", false);
        } else if (config.netty.address.startsWith("wss://")) {
            if (!config.netty.ipForwarding) {
                SecurityCheckCommand.printCheckResult("netty.ipForwarding", "ipForwarding not enabled. authLimiter may be get incorrect ip", null);
            }
            SecurityCheckCommand.printCheckResult("netty.address", "", true);
        }
        if (config.netty.launcherURL.startsWith("http://")) {
            SecurityCheckCommand.printCheckResult("netty.launcherUrl", "launcher jar download connection not secure", false);
        } else if (config.netty.launcherURL.startsWith("https://")) {
            SecurityCheckCommand.printCheckResult("netty.launcherUrl", "", true);
        }
        if (config.netty.launcherEXEURL.startsWith("http://")) {
            SecurityCheckCommand.printCheckResult("netty.launcherExeUrl", "launcher exe download connection not secure", false);
        } else if (config.netty.launcherEXEURL.startsWith("https://")) {
            SecurityCheckCommand.printCheckResult("netty.launcherExeUrl", "", true);
        }
        if (config.netty.downloadURL.startsWith("http://")) {
            SecurityCheckCommand.printCheckResult("netty.downloadUrl", "assets/clients download connection not secure", false);
        } else if (config.netty.downloadURL.startsWith("https://")) {
            SecurityCheckCommand.printCheckResult("netty.downloadUrl", "", true);
        }
        if (!config.sign.enabled) {
            SecurityCheckCommand.printCheckResult("sign", "it is recommended to use a signature", null);
        } else {
            boolean bad = false;
            try {
                KeyStore keyStore = SignHelper.getStore(new File(config.sign.keyStore).toPath(), config.sign.keyStorePass, config.sign.keyStoreType);
                Certificate[] certChainPlain = keyStore.getCertificateChain(config.sign.keyAlias);
                List certChain = Arrays.stream(certChainPlain).map(e -> (X509Certificate)e).collect(Collectors.toList());
                X509Certificate cert = (X509Certificate)certChain.get(0);
                cert.checkValidity();
                if (certChain.size() <= 1) {
                    SecurityCheckCommand.printCheckResult("sign", "certificate chain contains <2 element(recommend 2 and more)", false);
                    bad = true;
                }
                if ((cert.getBasicConstraints() & 1) == 1) {
                    SecurityCheckCommand.printCheckResult("sign", "end certificate - CA", false);
                    bad = true;
                }
                for (X509Certificate certificate : certChain) {
                    certificate.checkValidity();
                }
            }
            catch (Throwable e2) {
                logger.error("Sign check failed", e2);
                bad = true;
            }
            if (!bad) {
                SecurityCheckCommand.printCheckResult("sign", "", true);
            }
        }
        if (config.components.values().stream().noneMatch(c -> c instanceof ProGuardComponent)) {
            SecurityCheckCommand.printCheckResult("launcher.enabledProGuard", "proguard not enabled", false);
        } else {
            SecurityCheckCommand.printCheckResult("launcher.enabledProGuard", "", true);
        }
        if (!config.launcher.stripLineNumbers) {
            SecurityCheckCommand.printCheckResult("launcher.stripLineNumbers", "stripLineNumbers not enabled", false);
        } else {
            SecurityCheckCommand.printCheckResult("launcher.stripLineNumbers", "", true);
        }
        switch (config.env) {
            case DEV: {
                SecurityCheckCommand.printCheckResult("env", "found env DEV", false);
                break;
            }
            case DEBUG: {
                SecurityCheckCommand.printCheckResult("env", "found env DEBUG", false);
                break;
            }
            case STD: {
                SecurityCheckCommand.printCheckResult("env", "you can improve security by using env PROD", null);
                break;
            }
            case PROD: {
                SecurityCheckCommand.printCheckResult("env", "", true);
            }
        }
        for (ClientProfile profile : this.server.getProfiles()) {
            boolean bad = false;
            String profileModuleName = String.format("profiles.%s", profile.getTitle());
            for (String exc : profile.getUpdateExclusions()) {
                StringTokenizer tokenizer = new StringTokenizer(exc, "/");
                if (exc.endsWith(".jar")) {
                    SecurityCheckCommand.printCheckResult(profileModuleName, String.format("updateExclusions %s not safe. Cheats may be injected very easy!", exc), false);
                    bad = true;
                    continue;
                }
                if (!tokenizer.hasMoreTokens() || !tokenizer.nextToken().equals("mods")) continue;
                String nextToken = tokenizer.nextToken();
                if (!tokenizer.hasMoreTokens()) {
                    if (exc.endsWith("/")) continue;
                    SecurityCheckCommand.printCheckResult(profileModuleName, String.format("updateExclusions %s not safe. Cheats may be injected very easy!", exc), false);
                    bad = true;
                    continue;
                }
                if (!nextToken.equals("memory_repo") && !nextToken.equals(profile.getVersion().name)) continue;
                SecurityCheckCommand.printCheckResult(profileModuleName, String.format("updateExclusions %s not safe. Cheats may be injected very easy!", exc), false);
                bad = true;
            }
            if (bad) continue;
            SecurityCheckCommand.printCheckResult(profileModuleName, "", true);
        }
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            try {
                String[] status;
                int uid = 0;
                int gid = 0;
                for (String line : status = new String(IOHelper.read((Path)Paths.get("/proc/self/status", new String[0]))).split("\n")) {
                    String[] words;
                    String[] parts = line.split(":");
                    if (parts.length == 0) continue;
                    if (parts[0].trim().equalsIgnoreCase("Uid")) {
                        words = parts[1].trim().split(" ");
                        uid = Integer.parseInt(words[0]);
                        if (Integer.parseInt(words[0]) == 0 || Integer.parseInt(words[0]) == 0) {
                            logger.error("The process is started as root! It is not recommended");
                        }
                    }
                    if (!parts[0].trim().equalsIgnoreCase("Gid")) continue;
                    words = parts[1].trim().split(" ");
                    gid = Integer.parseInt(words[0]);
                    if (Integer.parseInt(words[0]) != 0 && Integer.parseInt(words[0]) != 0) continue;
                    logger.error("The process is started as root group! It is not recommended");
                }
                if (this.checkOtherWriteAccess(IOHelper.getCodeSource(LaunchServer.class))) {
                    logger.warn("Write access to LaunchServer.jar. Please use 'chmod 755 LaunchServer.jar'");
                }
                if (Files.exists(this.server.dir.resolve(".keys"), new LinkOption[0]) && this.checkOtherReadOrWriteAccess(this.server.dir.resolve(".keys"))) {
                    logger.warn("Write or read access to .keys directory. Please use 'chmod -R 600 .keys'");
                }
                if (Files.exists(this.server.dir.resolve("LaunchServerConfig.json"), new LinkOption[0]) && this.checkOtherReadOrWriteAccess(this.server.dir.resolve("LaunchServerConfig.json"))) {
                    logger.warn("Write or read access to LaunchServerConfig.json. Please use 'chmod 600 LaunchServerConfig.json'");
                }
                if (Files.exists(this.server.dir.resolve("LaunchServerRuntimeConfig.json"), new LinkOption[0]) && this.checkOtherReadOrWriteAccess(this.server.dir.resolve("LaunchServerRuntimeConfig.json"))) {
                    logger.warn("Write or read access to LaunchServerRuntimeConfig.json. Please use 'chmod 600 LaunchServerRuntimeConfig.json'");
                }
            }
            catch (IOException e3) {
                logger.error((Object)e3);
            }
        }
        logger.info("Check completed");
    }

    public boolean checkOtherWriteAccess(Path file) throws IOException {
        Set<PosixFilePermission> permissionSet = Files.getPosixFilePermissions(file, new LinkOption[0]);
        return permissionSet.contains((Object)PosixFilePermission.OTHERS_WRITE);
    }

    public boolean checkOtherReadOrWriteAccess(Path file) throws IOException {
        Set<PosixFilePermission> permissionSet = Files.getPosixFilePermissions(file, new LinkOption[0]);
        return permissionSet.contains((Object)PosixFilePermission.OTHERS_WRITE) || permissionSet.contains((Object)PosixFilePermission.OTHERS_READ);
    }
}

