/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.config.log4j;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractAppender;
import org.apache.logging.log4j.core.appender.AppenderLoggingException;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.layout.PatternLayout;

@Plugin(name="LogCollect", category="Core", elementType="appender", printObject=true)
public class LogAppender
extends AbstractAppender {
    private static volatile LogAppender INSTANCE;
    private final Set<Consumer<LogEvent>> set = new HashSet<Consumer<LogEvent>>();

    public LogAppender(String name, Filter filter, Layout<? extends Serializable> layout, boolean ignoreExceptions, Property[] properties) {
        super(name, filter, layout, ignoreExceptions, properties);
        INSTANCE = this;
    }

    public static LogAppender getInstance() {
        return INSTANCE;
    }

    @PluginFactory
    public static LogAppender createAppender(@PluginAttribute(value="name") String name, @PluginElement(value="Layout") Layout<? extends Serializable> layout, @PluginElement(value="Filter") Filter filter, @PluginAttribute(value="otherAttribute") String otherAttribute) {
        if (name == null) {
            LOGGER.error("No name provided for MyCustomAppenderImpl");
            return null;
        }
        if (layout == null) {
            layout = PatternLayout.createDefaultLayout();
        }
        return new LogAppender(name, filter, (Layout<? extends Serializable>)layout, true, Property.EMPTY_ARRAY);
    }

    public void append(LogEvent event) {
        block3: {
            try {
                for (Consumer<LogEvent> consumer : this.set) {
                    consumer.accept(event);
                }
            }
            catch (Throwable e) {
                if (this.ignoreExceptions()) break block3;
                throw new AppenderLoggingException(e);
            }
        }
    }

    public void addListener(Consumer<LogEvent> consumer) {
        this.set.add(consumer);
    }

    public void removeListener(Consumer<LogEvent> consumer) {
        this.set.remove(consumer);
    }
}

