/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class KeyAgreementManager {
    public final ECPublicKey ecdsaPublicKey;
    public final ECPrivateKey ecdsaPrivateKey;
    public final RSAPublicKey rsaPublicKey;
    public final RSAPrivateKey rsaPrivateKey;
    public final String legacySalt;
    private final transient Logger logger = LogManager.getLogger();

    public KeyAgreementManager(ECPublicKey ecdsaPublicKey, ECPrivateKey ecdsaPrivateKey, RSAPublicKey rsaPublicKey, RSAPrivateKey rsaPrivateKey, String legacySalt) {
        this.ecdsaPublicKey = ecdsaPublicKey;
        this.ecdsaPrivateKey = ecdsaPrivateKey;
        this.rsaPublicKey = rsaPublicKey;
        this.rsaPrivateKey = rsaPrivateKey;
        this.legacySalt = legacySalt;
    }

    public KeyAgreementManager(Path keyDirectory) throws IOException, InvalidKeySpecException {
        Path ecdsaPublicKeyPath = keyDirectory.resolve("ecdsa_id.pub");
        Path ecdsaPrivateKeyPath = keyDirectory.resolve("ecdsa_id");
        if (IOHelper.isFile((Path)ecdsaPublicKeyPath) && IOHelper.isFile((Path)ecdsaPrivateKeyPath)) {
            this.logger.info("Reading ECDSA keypair");
            this.ecdsaPublicKey = SecurityHelper.toPublicECDSAKey((byte[])IOHelper.read((Path)ecdsaPublicKeyPath));
            this.ecdsaPrivateKey = SecurityHelper.toPrivateECDSAKey((byte[])IOHelper.read((Path)ecdsaPrivateKeyPath));
        } else {
            this.logger.info("Generating ECDSA keypair");
            KeyPair pair = SecurityHelper.genECDSAKeyPair((SecureRandom)new SecureRandom());
            this.ecdsaPublicKey = (ECPublicKey)pair.getPublic();
            this.ecdsaPrivateKey = (ECPrivateKey)pair.getPrivate();
            this.logger.info("Writing ECDSA keypair list");
            IOHelper.write((Path)ecdsaPublicKeyPath, (byte[])this.ecdsaPublicKey.getEncoded());
            IOHelper.write((Path)ecdsaPrivateKeyPath, (byte[])this.ecdsaPrivateKey.getEncoded());
        }
        Path rsaPublicKeyPath = keyDirectory.resolve("rsa_id.pub");
        Path rsaPrivateKeyPath = keyDirectory.resolve("rsa_id");
        if (IOHelper.isFile((Path)rsaPublicKeyPath) && IOHelper.isFile((Path)rsaPrivateKeyPath)) {
            this.logger.info("Reading RSA keypair");
            this.rsaPublicKey = SecurityHelper.toPublicRSAKey((byte[])IOHelper.read((Path)rsaPublicKeyPath));
            this.rsaPrivateKey = SecurityHelper.toPrivateRSAKey((byte[])IOHelper.read((Path)rsaPrivateKeyPath));
        } else {
            this.logger.info("Generating RSA keypair");
            KeyPair pair = SecurityHelper.genRSAKeyPair((SecureRandom)new SecureRandom());
            this.rsaPublicKey = (RSAPublicKey)pair.getPublic();
            this.rsaPrivateKey = (RSAPrivateKey)pair.getPrivate();
            this.logger.info("Writing RSA keypair list");
            IOHelper.write((Path)rsaPublicKeyPath, (byte[])this.rsaPublicKey.getEncoded());
            IOHelper.write((Path)rsaPrivateKeyPath, (byte[])this.rsaPrivateKey.getEncoded());
        }
        Path legacySaltPath = keyDirectory.resolve("legacySalt");
        if (IOHelper.isFile((Path)legacySaltPath)) {
            this.legacySalt = new String(IOHelper.read((Path)legacySaltPath), StandardCharsets.UTF_8);
        } else {
            this.legacySalt = SecurityHelper.randomStringToken();
            IOHelper.write((Path)legacySaltPath, (byte[])this.legacySalt.getBytes(StandardCharsets.UTF_8));
        }
    }
}

