/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class Client {
    public String auth_id;
    public long timestamp = System.currentTimeMillis();
    public AuthResponse.ConnectTypes type = null;
    public ClientProfile profile;
    public boolean isAuth = false;
    public boolean checkSign = false;
    public ClientPermissions permissions = new ClientPermissions();
    public String username = "";
    public UUID uuid;
    public TrustLevel trustLevel;
    public transient AuthProviderPair auth;
    public transient User coreObject;
    public transient UserSession sessionObject;
    public transient Map<String, Object> properties;
    public Map<String, Object> staticProperties;

    public void up() {
        this.timestamp = System.currentTimeMillis();
    }

    public void updateAuth(LaunchServer server) {
        if (!this.isAuth) {
            return;
        }
        this.auth = this.auth_id.isEmpty() ? server.config.getAuthProviderPair() : server.config.getAuthProviderPair(this.auth_id);
    }

    public <T> T getProperty(String name) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return (T)this.properties.get(name);
    }

    public <T> void setProperty(String name, T object) {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        this.properties.put(name, object);
    }

    public <T> T getStaticProperty(String name) {
        if (this.staticProperties == null) {
            this.staticProperties = new HashMap<String, Object>();
        }
        return (T)this.staticProperties.get(name);
    }

    public <T> void setStaticProperty(String name, T value) {
        if (this.staticProperties == null) {
            this.staticProperties = new HashMap<String, Object>();
        }
        this.staticProperties.put(name, value);
    }

    public User getUser() {
        if (this.coreObject != null) {
            return this.coreObject;
        }
        if (this.auth != null && this.uuid != null) {
            this.coreObject = this.auth.core.getUserByUUID(this.uuid);
        }
        return this.coreObject;
    }

    public static class TrustLevel {
        public byte[] verifySecureKey;
        public boolean keyChecked;
        public byte[] publicKey;
        public HardwareReportRequest.HardwareInfo hardwareInfo;
        public double rating;
        public long latestMillis;
    }
}

