/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import com.mysql.cj.jdbc.MysqlDataSource;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.IntPredicate;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.auth.SQLSourceConfig;
import pro.gravit.utils.helper.VerifyHelper;

public final class MySQLSourceConfig
implements AutoCloseable,
SQLSourceConfig {
    public static final int TIMEOUT = VerifyHelper.verifyInt((int)Integer.parseUnsignedInt(System.getProperty("launcher.mysql.idleTimeout", Integer.toString(5000))), (IntPredicate)VerifyHelper.POSITIVE, (String)"launcher.mysql.idleTimeout can't be <= 5000");
    private static final int MAX_POOL_SIZE = VerifyHelper.verifyInt((int)Integer.parseUnsignedInt(System.getProperty("launcher.mysql.maxPoolSize", Integer.toString(3))), (IntPredicate)VerifyHelper.POSITIVE, (String)"launcher.mysql.maxPoolSize can't be <= 0");
    private final transient String poolName;
    private final transient Logger logger = LogManager.getLogger();
    private String address;
    private int port;
    private boolean useSSL;
    private boolean verifyCertificates;
    private String username;
    private String password;
    private String database;
    private String timezone;
    private boolean useHikari;
    private transient DataSource source;
    private transient boolean hikari;

    public MySQLSourceConfig(String poolName) {
        this.poolName = poolName;
    }

    public MySQLSourceConfig(String poolName, String address, int port, String username, String password, String database) {
        this.poolName = poolName;
        this.address = address;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
    }

    public MySQLSourceConfig(String poolName, DataSource source, boolean hikari) {
        this.poolName = poolName;
        this.source = source;
        this.hikari = hikari;
    }

    @Override
    public synchronized void close() {
        if (this.hikari) {
            ((HikariDataSource)this.source).close();
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.source == null) {
            MysqlDataSource mysqlSource = new MysqlDataSource();
            mysqlSource.setCharacterEncoding("UTF-8");
            mysqlSource.setPrepStmtCacheSize(250);
            mysqlSource.setPrepStmtCacheSqlLimit(2048);
            mysqlSource.setCachePrepStmts(true);
            mysqlSource.setUseServerPrepStmts(true);
            mysqlSource.setCacheServerConfiguration(true);
            mysqlSource.setUseLocalSessionState(true);
            mysqlSource.setRewriteBatchedStatements(true);
            mysqlSource.setMaintainTimeStats(false);
            mysqlSource.setUseUnbufferedInput(false);
            mysqlSource.setUseReadAheadInput(false);
            mysqlSource.setUseSSL(this.useSSL);
            mysqlSource.setVerifyServerCertificate(this.verifyCertificates);
            mysqlSource.setServerName(this.address);
            mysqlSource.setPortNumber(this.port);
            mysqlSource.setUser(this.username);
            mysqlSource.setPassword(this.password);
            mysqlSource.setDatabaseName(this.database);
            mysqlSource.setTcpNoDelay(true);
            if (this.timezone != null) {
                mysqlSource.setServerTimezone(this.timezone);
            }
            this.hikari = false;
            this.source = mysqlSource;
            if (this.useHikari) {
                try {
                    Class.forName("com.zaxxer.hikari.HikariDataSource");
                    this.hikari = true;
                    HikariConfig hikariConfig = new HikariConfig();
                    hikariConfig.setDataSource((DataSource)mysqlSource);
                    hikariConfig.setPoolName(this.poolName);
                    hikariConfig.setMinimumIdle(1);
                    hikariConfig.setMaximumPoolSize(MAX_POOL_SIZE);
                    hikariConfig.setConnectionTestQuery("SELECT 1");
                    hikariConfig.setConnectionTimeout(1000L);
                    hikariConfig.setAutoCommit(true);
                    hikariConfig.setLeakDetectionThreshold(2000L);
                    this.source = new HikariDataSource(hikariConfig);
                }
                catch (ClassNotFoundException ignored) {
                    this.logger.debug("HikariCP isn't in classpath for '{}'", (Object)this.poolName);
                }
            }
        }
        return this.source.getConnection();
    }
}

