/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import com.zaxxer.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.function.IntPredicate;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.postgresql.ds.PGSimpleDataSource;
import pro.gravit.launchserver.auth.SQLSourceConfig;
import pro.gravit.utils.helper.VerifyHelper;

public final class PostgreSQLSourceConfig
implements AutoCloseable,
SQLSourceConfig {
    public static final int TIMEOUT = VerifyHelper.verifyInt((int)Integer.parseUnsignedInt(System.getProperty("launcher.postgresql.idleTimeout", Integer.toString(5000))), (IntPredicate)VerifyHelper.POSITIVE, (String)"launcher.postgresql.idleTimeout can't be <= 5000");
    private static final int MAX_POOL_SIZE = VerifyHelper.verifyInt((int)Integer.parseUnsignedInt(System.getProperty("launcher.postgresql.maxPoolSize", Integer.toString(3))), (IntPredicate)VerifyHelper.POSITIVE, (String)"launcher.postgresql.maxPoolSize can't be <= 0");
    private final transient Logger logger = LogManager.getLogger();
    private String poolName;
    private String[] addresses;
    private int[] ports;
    private String username;
    private String password;
    private String database;
    private transient DataSource source;
    private transient boolean hikari;

    @Override
    public synchronized void close() {
        if (this.hikari) {
            ((HikariDataSource)this.source).close();
        }
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        if (this.source == null) {
            PGSimpleDataSource postgresqlSource = new PGSimpleDataSource();
            postgresqlSource.setServerNames(this.addresses);
            postgresqlSource.setPortNumbers(this.ports);
            postgresqlSource.setUser(this.username);
            postgresqlSource.setPassword(this.password);
            postgresqlSource.setDatabaseName(this.database);
            this.source = postgresqlSource;
            try {
                Class.forName("com.zaxxer.hikari.HikariDataSource");
                this.hikari = true;
                HikariDataSource hikariSource = new HikariDataSource();
                hikariSource.setDataSource(this.source);
                hikariSource.setPoolName(this.poolName);
                hikariSource.setMinimumIdle(0);
                hikariSource.setMaximumPoolSize(MAX_POOL_SIZE);
                hikariSource.setIdleTimeout((long)TIMEOUT * 1000L);
                this.source = hikariSource;
                this.logger.info("HikariCP pooling enabled for '{}'", (Object)this.poolName);
            }
            catch (ClassNotFoundException ignored) {
                this.logger.warn("HikariCP isn't in classpath for '{}'", (Object)this.poolName);
            }
        }
        return this.source.getConnection();
    }
}

