/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.HookException;

public class AuthResponse
extends SimpleResponse {
    private final transient Logger logger = LogManager.getLogger();
    public String login;
    public String client;
    public AuthRequest.AuthPasswordInterface password;
    public String auth_id;
    public ConnectTypes authType;

    @Override
    public String getType() {
        return "auth";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client clientData) throws Exception {
        try {
            AuthRequestEvent result = new AuthRequestEvent();
            AuthProviderPair pair = this.auth_id == null || this.auth_id.isEmpty() ? this.server.config.getAuthProviderPair() : this.server.config.getAuthProviderPair(this.auth_id);
            if (pair == null) {
                this.sendError("auth_id incorrect");
                return;
            }
            AuthContext context = this.server.authManager.makeAuthContext(clientData, this.authType, pair, this.login, this.client, this.ip);
            this.server.authManager.check(context);
            this.password = this.server.authManager.decryptPassword(this.password);
            this.server.authHookManager.preHook.hook((Object)context, (Object)clientData);
            context.report = this.server.authManager.auth(context, this.password);
            this.server.authHookManager.postHook.hook((Object)context, (Object)clientData);
            ClientPermissions clientPermissions = context.report.session() != null ? (context.report.session().getUser() != null ? context.report.session().getUser().getPermissions() : null) : (result.permissions = null);
            if (context.report.isUsingOAuth()) {
                result.oauth = new AuthRequestEvent.OAuthRequestEvent(context.report.oauthAccessToken(), context.report.oauthRefreshToken(), context.report.oauthExpire());
            }
            if (context.report.minecraftAccessToken() != null) {
                result.accessToken = context.report.minecraftAccessToken();
            }
            result.playerProfile = this.server.authManager.getPlayerProfile(clientData);
            this.sendResult((RequestEvent)result);
        }
        catch (AuthException | HookException e) {
            this.sendError(e.getMessage());
        }
    }

    public static enum ConnectTypes {
        CLIENT,
        API;

    }

    public static class AuthContext {
        public final String login;
        public final String profileName;
        public final String ip;
        public final ConnectTypes authType;
        public final transient Client client;
        public final transient AuthProviderPair pair;
        public transient AuthManager.AuthReport report;

        public AuthContext(Client client, String login, String profileName, String ip, ConnectTypes authType, AuthProviderPair pair) {
            this.client = client;
            this.login = login;
            this.profileName = profileName;
            this.ip = ip;
            this.authType = authType;
            this.pair = pair;
        }
    }
}

