/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class MergeAuthCoreProvider
extends AuthCoreProvider {
    private final transient Logger logger = LogManager.getLogger(MergeAuthCoreProvider.class);
    public List<String> list = new ArrayList<String>();
    private transient List<AuthCoreProvider> providers = new ArrayList<AuthCoreProvider>();

    @Override
    public User getUserByUsername(String username) {
        for (AuthCoreProvider core : this.providers) {
            User result = core.getUserByUsername(username);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public User getUserByUUID(UUID uuid) {
        for (AuthCoreProvider core : this.providers) {
            User result = core.getUserByUUID(uuid);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) throws AuthCoreProvider.OAuthAccessTokenExpired {
        throw new AuthCoreProvider.OAuthAccessTokenExpired();
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String refreshToken, AuthResponse.AuthContext context) {
        return null;
    }

    @Override
    public AuthManager.AuthReport authorize(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        throw new AuthException("Authorization not supported");
    }

    @Override
    public User checkServer(Client client, String username, String serverID) throws IOException {
        for (AuthCoreProvider core : this.providers) {
            User result = core.checkServer(client, username, serverID);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean joinServer(Client client, String username, String accessToken, String serverID) throws IOException {
        return false;
    }

    @Override
    public void init(LaunchServer server) {
        for (String e : this.list) {
            AuthProviderPair pair = server.config.auth.get(e);
            if (pair != null) {
                this.providers.add(pair.core);
                continue;
            }
            this.logger.warn("Provider {} not found", (Object)e);
        }
    }

    @Override
    public void close() throws IOException {
    }
}

