/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.LinkedList;
import java.util.UUID;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.request.secure.HardwareReportRequest;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.MySQLSourceConfig;
import pro.gravit.launchserver.auth.SQLSourceConfig;
import pro.gravit.launchserver.auth.core.AbstractSQLCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.UserHardware;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportHardware;
import pro.gravit.utils.helper.IOHelper;

public class MySQLCoreProvider
extends AbstractSQLCoreProvider
implements AuthSupportHardware {
    public MySQLSourceConfig mySQLHolder;
    public String hardwareIdColumn;
    public String tableHWID = "hwids";
    public String tableHWIDLog = "hwidLog";
    public double criticalCompareLevel = 1.0;
    private transient String sqlFindHardwareByPublicKey;
    private transient String sqlFindHardwareByData;
    private transient String sqlFindHardwareById;
    private transient String sqlCreateHardware;
    private transient String sqlCreateHWIDLog;
    private transient String sqlUpdateHardwarePublicKey;
    private transient String sqlUpdateHardwareBanned;
    private transient String sqlUpdateUsers;
    private transient String sqlUsersByHwidId;

    @Override
    public SQLSourceConfig getSQLConfig() {
        return this.mySQLHolder;
    }

    @Override
    public void init(LaunchServer server) {
        super.init(server);
        String userInfoCols = this.makeUserCols();
        String hardwareInfoCols = "id, hwDiskId, baseboardSerialNumber, displayId, bitness, totalMemory, logicalProcessors, physicalProcessors, processorMaxFreq, battery, id, graphicCard, banned, publicKey";
        if (this.sqlFindHardwareByPublicKey == null) {
            this.sqlFindHardwareByPublicKey = String.format("SELECT %s FROM %s WHERE `publicKey` = ?", hardwareInfoCols, this.tableHWID);
        }
        if (this.sqlFindHardwareById == null) {
            this.sqlFindHardwareById = String.format("SELECT %s FROM %s WHERE `id` = ?", hardwareInfoCols, this.tableHWID);
        }
        if (this.sqlUsersByHwidId == null) {
            this.sqlUsersByHwidId = String.format("SELECT %s FROM %s WHERE `%s` = ?", userInfoCols, this.table, this.hardwareIdColumn);
        }
        if (this.sqlFindHardwareByData == null) {
            this.sqlFindHardwareByData = String.format("SELECT %s FROM %s", hardwareInfoCols, this.tableHWID);
        }
        if (this.sqlCreateHardware == null) {
            this.sqlCreateHardware = String.format("INSERT INTO `%s` (`publickey`, `hwDiskId`, `baseboardSerialNumber`, `displayId`, `bitness`, `totalMemory`, `logicalProcessors`, `physicalProcessors`, `processorMaxFreq`, `graphicCard`, `battery`, `banned`) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, '0')", this.tableHWID);
        }
        if (this.sqlCreateHWIDLog == null) {
            this.sqlCreateHWIDLog = String.format("INSERT INTO %s (`hwidId`, `newPublicKey`) VALUES (?, ?)", this.tableHWIDLog);
        }
        if (this.sqlUpdateHardwarePublicKey == null) {
            this.sqlUpdateHardwarePublicKey = String.format("UPDATE %s SET `publicKey` = ? WHERE `id` = ?", this.tableHWID);
        }
        this.sqlUpdateHardwareBanned = String.format("UPDATE %s SET `banned` = ? WHERE `id` = ?", this.tableHWID);
        this.sqlUpdateUsers = String.format("UPDATE %s SET `%s` = ? WHERE `%s` = ?", this.table, this.hardwareIdColumn, this.uuidColumn);
    }

    @Override
    protected String makeUserCols() {
        return super.makeUserCols().concat(", ").concat(this.hardwareIdColumn);
    }

    @Override
    protected MySQLUser constructUser(ResultSet set) throws SQLException {
        return set.next() ? new MySQLUser(UUID.fromString(set.getString(this.uuidColumn)), set.getString(this.usernameColumn), set.getString(this.accessTokenColumn), set.getString(this.serverIDColumn), set.getString(this.passwordColumn), this.requestPermissions(set.getString(this.uuidColumn)), set.getLong(this.hardwareIdColumn)) : null;
    }

    private MySQLUserHardware fetchHardwareInfo(ResultSet set) throws SQLException, IOException {
        HardwareReportRequest.HardwareInfo hardwareInfo = new HardwareReportRequest.HardwareInfo();
        hardwareInfo.hwDiskId = set.getString("hwDiskId");
        hardwareInfo.baseboardSerialNumber = set.getString("baseboardSerialNumber");
        Blob displayId = set.getBlob("displayId");
        hardwareInfo.displayId = displayId == null ? null : IOHelper.read((InputStream)displayId.getBinaryStream());
        hardwareInfo.bitness = set.getInt("bitness");
        hardwareInfo.totalMemory = set.getLong("totalMemory");
        hardwareInfo.logicalProcessors = set.getInt("logicalProcessors");
        hardwareInfo.physicalProcessors = set.getInt("physicalProcessors");
        hardwareInfo.processorMaxFreq = set.getLong("processorMaxFreq");
        hardwareInfo.battery = set.getBoolean("battery");
        hardwareInfo.graphicCard = set.getString("graphicCard");
        Blob publicKey = set.getBlob("publicKey");
        long id = set.getLong("id");
        boolean banned = set.getBoolean("banned");
        return new MySQLUserHardware(hardwareInfo, publicKey == null ? null : IOHelper.read((InputStream)publicKey.getBinaryStream()), id, banned);
    }

    private void setUserHardwareId(Connection connection, UUID uuid, long hwidId) throws SQLException {
        PreparedStatement s = connection.prepareStatement(this.sqlUpdateUsers);
        s.setLong(1, hwidId);
        s.setString(2, uuid.toString());
        s.executeUpdate();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware getHardwareInfoByPublicKey(byte[] publicKey) {
        try (Connection connection = this.mySQLHolder.getConnection();){
            UserHardware userHardware;
            block18: {
                ResultSet set;
                block16: {
                    MySQLUserHardware mySQLUserHardware;
                    block17: {
                        PreparedStatement s = connection.prepareStatement(this.sqlFindHardwareByPublicKey);
                        s.setBlob(1, new ByteArrayInputStream(publicKey));
                        set = s.executeQuery();
                        try {
                            if (!set.next()) break block16;
                            mySQLUserHardware = this.fetchHardwareInfo(set);
                            if (set == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (set != null) {
                                try {
                                    set.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        set.close();
                    }
                    return mySQLUserHardware;
                }
                userHardware = null;
                if (set == null) break block18;
                set.close();
            }
            return userHardware;
        }
        catch (IOException | SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware getHardwareInfoByData(HardwareReportRequest.HardwareInfo info) {
        try (Connection connection = this.mySQLHolder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlFindHardwareByData);
            try (ResultSet set = s.executeQuery();){
                MySQLUserHardware hw;
                AuthSupportHardware.HardwareInfoCompareResult result;
                do {
                    if (!set.next()) return null;
                    hw = this.fetchHardwareInfo(set);
                    result = this.compareHardwareInfo(hw.getHardwareInfo(), info);
                } while (!(result.compareLevel > this.criticalCompareLevel));
                MySQLUserHardware mySQLUserHardware = hw;
                return mySQLUserHardware;
            }
        }
        catch (IOException | SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware getHardwareInfoById(String id) {
        try (Connection connection = this.mySQLHolder.getConnection();){
            UserHardware userHardware;
            block18: {
                ResultSet set;
                block16: {
                    MySQLUserHardware mySQLUserHardware;
                    block17: {
                        PreparedStatement s = connection.prepareStatement(this.sqlFindHardwareById);
                        s.setLong(1, Long.parseLong(id));
                        set = s.executeQuery();
                        try {
                            if (!set.next()) break block16;
                            mySQLUserHardware = this.fetchHardwareInfo(set);
                            if (set == null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (set != null) {
                                try {
                                    set.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        set.close();
                    }
                    return mySQLUserHardware;
                }
                userHardware = null;
                if (set == null) break block18;
                set.close();
            }
            return userHardware;
        }
        catch (IOException | SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public UserHardware createHardwareInfo(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey) {
        try (Connection connection = this.mySQLHolder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlCreateHardware, 1);
            s.setBlob(1, new ByteArrayInputStream(publicKey));
            s.setString(2, hardwareInfo.hwDiskId);
            s.setString(3, hardwareInfo.baseboardSerialNumber);
            s.setBlob(4, hardwareInfo.displayId == null ? null : new ByteArrayInputStream(hardwareInfo.displayId));
            s.setInt(5, hardwareInfo.bitness);
            s.setLong(6, hardwareInfo.totalMemory);
            s.setInt(7, hardwareInfo.logicalProcessors);
            s.setInt(8, hardwareInfo.physicalProcessors);
            s.setLong(9, hardwareInfo.processorMaxFreq);
            s.setString(10, hardwareInfo.graphicCard);
            s.setBoolean(11, hardwareInfo.battery);
            s.executeUpdate();
            try (ResultSet generatedKeys = s.getGeneratedKeys();){
                if (generatedKeys.next()) {
                    long id = generatedKeys.getLong(1);
                    MySQLUserHardware mySQLUserHardware = new MySQLUserHardware(hardwareInfo, publicKey, id, false);
                    return mySQLUserHardware;
                }
            }
            UserHardware userHardware = null;
            return userHardware;
        }
        catch (SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
            return null;
        }
    }

    @Override
    public void connectUserAndHardware(UserSession userSession, UserHardware hardware) {
        AbstractSQLCoreProvider.SQLUserSession mySQLUserSession = (AbstractSQLCoreProvider.SQLUserSession)userSession;
        MySQLUser mySQLUser = (MySQLUser)mySQLUserSession.getUser();
        MySQLUserHardware mySQLUserHardware = (MySQLUserHardware)hardware;
        if (mySQLUser.hwidId == mySQLUserHardware.id) {
            return;
        }
        mySQLUser.hwidId = mySQLUserHardware.id;
        try (Connection connection = this.mySQLHolder.getConnection();){
            this.setUserHardwareId(connection, mySQLUser.getUUID(), mySQLUserHardware.id);
        }
        catch (SQLException throwables) {
            this.logger.error("SQL Error", (Throwable)throwables);
        }
    }

    @Override
    public void addPublicKeyToHardwareInfo(UserHardware hardware, byte[] publicKey) {
        MySQLUserHardware mySQLUserHardware = (MySQLUserHardware)hardware;
        mySQLUserHardware.publicKey = publicKey;
        try (Connection connection = this.mySQLHolder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlUpdateHardwarePublicKey);
            s.setBlob(1, new ByteArrayInputStream(publicKey));
            s.setLong(2, mySQLUserHardware.id);
            s.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("SQL error", (Throwable)e);
        }
    }

    @Override
    public Iterable<User> getUsersByHardwareInfo(UserHardware hardware) {
        LinkedList<User> users = new LinkedList<User>();
        try (Connection c = this.mySQLHolder.getConnection();){
            PreparedStatement s = c.prepareStatement(this.sqlUsersByHwidId);
            s.setLong(1, Long.parseLong(hardware.getId()));
            s.setQueryTimeout(MySQLSourceConfig.TIMEOUT);
            try (ResultSet set = s.executeQuery();){
                while (!set.isLast()) {
                    users.add(this.constructUser(set));
                }
            }
        }
        catch (SQLException e) {
            this.logger.error("SQL error", (Throwable)e);
            return null;
        }
        return users;
    }

    @Override
    public void banHardware(UserHardware hardware) {
        MySQLUserHardware mySQLUserHardware = (MySQLUserHardware)hardware;
        mySQLUserHardware.banned = true;
        try (Connection connection = this.mySQLHolder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlUpdateHardwareBanned);
            s.setBoolean(1, true);
            s.setLong(2, mySQLUserHardware.id);
            s.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("SQL Error", (Throwable)e);
        }
    }

    @Override
    public void unbanHardware(UserHardware hardware) {
        MySQLUserHardware mySQLUserHardware = (MySQLUserHardware)hardware;
        mySQLUserHardware.banned = false;
        try (Connection connection = this.mySQLHolder.getConnection();){
            PreparedStatement s = connection.prepareStatement(this.sqlUpdateHardwareBanned);
            s.setBoolean(1, false);
            s.setLong(2, mySQLUserHardware.id);
            s.executeUpdate();
        }
        catch (SQLException e) {
            this.logger.error("SQL error", (Throwable)e);
        }
    }

    public class MySQLUser
    extends AbstractSQLCoreProvider.SQLUser
    implements UserSupportHardware {
        protected long hwidId;
        protected transient MySQLUserHardware hardware;

        public MySQLUser(UUID uuid, String username, String accessToken, String serverId, String password, ClientPermissions permissions, long hwidId) {
            super(uuid, username, accessToken, serverId, password, permissions);
            this.hwidId = hwidId;
        }

        @Override
        public UserHardware getHardware() {
            MySQLUserHardware result;
            if (this.hardware != null) {
                return this.hardware;
            }
            this.hardware = result = (MySQLUserHardware)MySQLCoreProvider.this.getHardwareInfoById(String.valueOf(this.hwidId));
            return result;
        }

        @Override
        public String toString() {
            return "MySQLUser{uuid=" + this.uuid + ", username='" + this.username + "', permissions=" + this.permissions + ", hwidId=" + this.hwidId + "}";
        }
    }

    public static class MySQLUserHardware
    implements UserHardware {
        private final HardwareReportRequest.HardwareInfo hardwareInfo;
        private final long id;
        private byte[] publicKey;
        private boolean banned;

        public MySQLUserHardware(HardwareReportRequest.HardwareInfo hardwareInfo, byte[] publicKey, long id, boolean banned) {
            this.hardwareInfo = hardwareInfo;
            this.publicKey = publicKey;
            this.id = id;
            this.banned = banned;
        }

        @Override
        public HardwareReportRequest.HardwareInfo getHardwareInfo() {
            return this.hardwareInfo;
        }

        @Override
        public byte[] getPublicKey() {
            return this.publicKey;
        }

        @Override
        public String getId() {
            return String.valueOf(this.id);
        }

        @Override
        public boolean isBanned() {
            return this.banned;
        }

        public String toString() {
            return "MySQLUserHardware{hardwareInfo=" + this.hardwareInfo + ", publicKey=" + (this.publicKey == null ? null : new String(Base64.getEncoder().encode(this.publicKey))) + ", id=" + this.id + ", banned=" + this.banned + "}";
        }
    }
}

