/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.protect;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.interfaces.ProfilesProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class StdProtectHandler
extends ProtectHandler
implements ProfilesProtectHandler {
    private final transient Logger logger = LogManager.getLogger();
    public Map<String, List<String>> profileWhitelist = new HashMap<String, List<String>>();
    public List<String> allowUpdates = new ArrayList<String>();

    @Override
    public boolean allowGetAccessToken(AuthResponse.AuthContext context) {
        return context.authType == AuthResponse.ConnectTypes.CLIENT && context.client.checkSign;
    }

    @Override
    public void checkLaunchServerLicense() {
    }

    @Override
    public void init(LaunchServer server) {
        if (this.profileWhitelist != null && this.profileWhitelist.size() > 0) {
            this.logger.warn("profileWhitelist deprecated. Please use permission 'launchserver.profile.PROFILE_UUID.show' and 'launchserver.profile.PROFILE_UUID.enter'");
        }
    }

    @Override
    public boolean canGetProfile(ClientProfile profile, Client client) {
        return !profile.isLimited() || this.isWhitelisted("launchserver.profile.%s.show", profile, client);
    }

    @Override
    public boolean canChangeProfile(ClientProfile profile, Client client) {
        return !profile.isLimited() || this.isWhitelisted("launchserver.profile.%s.enter", profile, client);
    }

    @Override
    public boolean canGetUpdates(String updatesDirName, Client client) {
        return client.profile != null && (client.profile.getDir().equals(updatesDirName) || client.profile.getAssetDir().equals(updatesDirName) || this.allowUpdates.contains(updatesDirName));
    }

    private boolean isWhitelisted(String property, ClientProfile profile, Client client) {
        List<String> allowedUsername;
        if (client.permissions != null) {
            String permByUUID = String.format(property, profile.getUUID());
            if (client.permissions.hasPerm(permByUUID)) {
                return true;
            }
            String permByTitle = String.format(property, profile.getTitle().toLowerCase(Locale.ROOT));
            if (client.permissions.hasPerm(permByTitle)) {
                return true;
            }
        }
        return (allowedUsername = this.profileWhitelist.get(profile.getTitle())) != null && allowedUsername.contains(client.username);
    }
}

