/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.helper.MakeProfileHelper;
import pro.gravit.utils.helper.IOHelper;

public class MakeProfileCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public MakeProfileCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[name] [minecraft version] [dir]";
    }

    public String getUsageDescription() {
        return "make profile for any minecraft versions";
    }

    public void invoke(String ... args) throws Exception {
        MakeProfileHelper.MakeProfileOption[] options;
        this.verifyArgs(args, 3);
        ClientProfile.Version version = ClientProfile.Version.byName((String)args[1]);
        for (MakeProfileHelper.MakeProfileOption option : options = MakeProfileHelper.getMakeProfileOptionsFromDir(this.server.updatesDir.resolve(args[2]), version, Files.exists(this.server.updatesDir.resolve("assets"), new LinkOption[0]))) {
            this.logger.info("Detected option {}", (Object)option);
        }
        ClientProfile profile = MakeProfileHelper.makeProfile(ClientProfile.Version.byName((String)args[1]), args[0], options);
        try (BufferedWriter writer = IOHelper.newWriter((Path)this.server.profilesDir.resolve(args[0].concat(".json")));){
            Launcher.gsonManager.configGson.toJson((Object)profile, (Appendable)writer);
        }
        this.logger.info("Profile {} created", (Object)args[0]);
        this.server.syncProfilesDir();
    }
}

