/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.interfaces.ProfilesProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class ProfilesResponse
extends SimpleResponse {
    public static List<ClientProfile> getListVisibleProfiles(LaunchServer server, Client client) {
        List<ClientProfile> profileList;
        Set<ClientProfile> serverProfiles = server.getProfiles();
        ProtectHandler protectHandler = server.config.protectHandler;
        if (protectHandler instanceof ProfilesProtectHandler) {
            ProfilesProtectHandler protectHandler2 = (ProfilesProtectHandler)((Object)protectHandler);
            profileList = new ArrayList<ClientProfile>(4);
            for (ClientProfile profile : serverProfiles) {
                if (!protectHandler2.canGetProfile(profile, client)) continue;
                profileList.add(profile);
            }
        } else {
            profileList = List.copyOf(serverProfiles);
        }
        return profileList;
    }

    @Override
    public String getType() {
        return "profiles";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        if (this.server.config.protectHandler instanceof ProfilesProtectHandler && !((ProfilesProtectHandler)((Object)this.server.config.protectHandler)).canGetProfiles(client)) {
            this.sendError("Access denied");
            return;
        }
        this.sendResult((RequestEvent)new ProfilesRequestEvent(ProfilesResponse.getListVisibleProfiles(this.server, client)));
    }
}

