/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.update;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.netty.channel.ChannelHandlerContext;
import java.security.Key;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.LauncherRequestEvent;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreResponse;
import pro.gravit.utils.Version;
import pro.gravit.utils.helper.SecurityHelper;

public class LauncherResponse
extends SimpleResponse {
    public Version version;
    public String hash;
    public byte[] digest;
    public int launcher_type;
    public String secureHash;
    public String secureSalt;

    @Override
    public String getType() {
        return "launcher";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        byte[] bytes = this.hash != null ? Base64.getDecoder().decode(this.hash) : this.digest;
        if (this.launcher_type == 1) {
            byte[] hash = this.server.launcherBinary.getDigest();
            if (hash == null) {
                this.service.sendObjectAndClose(ctx, new LauncherRequestEvent(true, this.server.config.netty.launcherURL));
            }
            if (Arrays.equals(bytes, hash) && this.checkSecure(this.secureHash, this.secureSalt)) {
                client.checkSign = true;
                this.sendResult((RequestEvent)new LauncherRequestEvent(false, this.server.config.netty.launcherURL, this.createLauncherExtendedToken()));
            } else {
                this.sendResultAndClose((RequestEvent)new LauncherRequestEvent(true, this.server.config.netty.launcherURL, this.createLauncherExtendedToken()));
            }
        } else if (this.launcher_type == 2) {
            byte[] hash = this.server.launcherEXEBinary.getDigest();
            if (hash == null) {
                this.sendResultAndClose((RequestEvent)new LauncherRequestEvent(true, this.server.config.netty.launcherEXEURL));
            }
            if (Arrays.equals(bytes, hash) && this.checkSecure(this.secureHash, this.secureSalt)) {
                client.checkSign = true;
                this.sendResult((RequestEvent)new LauncherRequestEvent(false, this.server.config.netty.launcherEXEURL, this.createLauncherExtendedToken()));
            } else {
                this.sendResultAndClose((RequestEvent)new LauncherRequestEvent(true, this.server.config.netty.launcherEXEURL, this.createLauncherExtendedToken()));
            }
        } else {
            this.sendError("Request launcher type error");
        }
    }

    public String createLauncherExtendedToken() {
        return Jwts.builder().setIssuer("LaunchServer").claim("checkSign", (Object)true).setExpiration(Date.from(LocalDateTime.now().plusSeconds(this.server.config.netty.security.launcherTokenExpire).toInstant(ZoneOffset.UTC))).signWith((Key)this.server.keyAgreementManager.ecdsaPrivateKey, SignatureAlgorithm.ES256).compact();
    }

    private boolean checkSecure(String hash, String salt) {
        if (hash == null || salt == null) {
            return false;
        }
        byte[] normal_hash = SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (String)this.server.runtime.clientCheckSecret.concat(".").concat(salt));
        byte[] launcher_hash = Base64.getDecoder().decode(hash);
        return Arrays.equals(normal_hash, launcher_hash);
    }

    public static class LauncherTokenVerifier
    implements RestoreResponse.ExtendedTokenProvider {
        private final JwtParser parser;
        private final Logger logger = LogManager.getLogger();

        public LauncherTokenVerifier(LaunchServer server) {
            this.parser = Jwts.parserBuilder().setSigningKey((Key)server.keyAgreementManager.ecdsaPublicKey).requireIssuer("LaunchServer").build();
        }

        @Override
        public boolean accept(Client client, AuthProviderPair pair, String extendedToken) {
            try {
                Jws jwt = this.parser.parseClaimsJws(extendedToken);
                client.checkSign = (Boolean)((Claims)jwt.getBody()).get("checkSign", Boolean.class);
                client.type = AuthResponse.ConnectTypes.CLIENT;
                return true;
            }
            catch (Exception e) {
                this.logger.error("JWT check failed", (Throwable)e);
                return false;
            }
        }
    }
}

