/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;

public final class AuthException
extends IOException {
    private static final long serialVersionUID = -2586107832847245863L;

    public AuthException(String message) {
        super(message);
    }

    public static AuthException need2FA() {
        return new AuthException("auth.require2fa");
    }

    public static AuthException needMFA(List<Integer> factors) {
        String message = "auth.require.factor.".concat(factors.stream().map(String::valueOf).collect(Collectors.joining(".")));
        return new AuthException(message);
    }

    public static AuthException wrongPassword() {
        return new AuthException("auth.wrongpassword");
    }

    public static AuthException userNotFound() {
        return new AuthException("auth.usernotfound");
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

