/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.AsyncDownloader;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.HttpRequester;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.utils.Downloader;
import pro.gravit.utils.helper.IOHelper;

public final class DownloadAssetCommand
extends Command {
    private static final String MINECRAFT_VERSIONS_URL = "https://launchermeta.mojang.com/mc/game/version_manifest.json";
    private static final String RESOURCES_DOWNLOAD_URL = "https://resources.download.minecraft.net/";
    private final transient Logger logger = LogManager.getLogger();

    public DownloadAssetCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[version] [dir] (mojang/mirror)";
    }

    public String getUsageDescription() {
        return "Download asset dir";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        String versionName = args[0];
        String dirName = IOHelper.verifyFileName((String)(args.length > 1 ? args[1] : "assets"));
        String type = args.length > 2 ? args[2] : "mojang";
        Path assetDir = this.server.updatesDir.resolve(dirName);
        if (Files.notExists(assetDir, new LinkOption[0])) {
            this.logger.info("Creating asset dir: '{}'", (Object)dirName);
            Files.createDirectory(assetDir, new FileAttribute[0]);
        }
        if (type.equals("mojang")) {
            HttpRequester requester = new HttpRequester();
            this.logger.info("Fetch versions from {}", (Object)MINECRAFT_VERSIONS_URL);
            MinecraftVersions versions = requester.send(requester.get(MINECRAFT_VERSIONS_URL, null), MinecraftVersions.class).getOrThrow();
            String profileUrl = null;
            for (MiniVersionInfo e : versions.versions) {
                if (!e.id.equals(versionName)) continue;
                profileUrl = e.url;
                break;
            }
            if (profileUrl == null) {
                this.logger.error("Version {} not found", (Object)versionName);
                return;
            }
            this.logger.info("Fetch profile {} from {}", (Object)versionName, profileUrl);
            MiniVersion profileInfo = requester.send(requester.get(profileUrl, null), MiniVersion.class).getOrThrow();
            String assetsIndexUrl = profileInfo.assetIndex.url;
            String assetIndex = profileInfo.assetIndex.id;
            Path indexPath = assetDir.resolve("indexes").resolve(assetIndex + ".json");
            this.logger.info("Fetch asset index {} from {}", (Object)assetIndex, (Object)assetsIndexUrl);
            JsonObject assets = requester.send(requester.get(assetsIndexUrl, null), JsonObject.class).getOrThrow();
            JsonObject objects = assets.get("objects").getAsJsonObject();
            try (BufferedWriter writer = IOHelper.newWriter((Path)indexPath);){
                this.logger.info("Save {}", (Object)indexPath);
                Launcher.gsonManager.configGson.toJson((JsonElement)assets, (Appendable)writer);
            }
            if (!assetIndex.equals(versionName)) {
                Path targetPath = assetDir.resolve("indexes").resolve(versionName + ".json");
                this.logger.info("Copy {} into {}", (Object)indexPath, (Object)targetPath);
                Files.copy(indexPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            ArrayList<AsyncDownloader.SizedFile> toDownload = new ArrayList<AsyncDownloader.SizedFile>(128);
            for (Map.Entry e : objects.entrySet()) {
                JsonObject value = ((JsonElement)e.getValue()).getAsJsonObject();
                Object hash = value.get("hash").getAsString();
                hash = ((String)hash).substring(0, 2) + "/" + (String)hash;
                long size = value.get("size").getAsLong();
                String path = "objects/" + (String)hash;
                Path target = assetDir.resolve(path);
                if (Files.exists(target, new LinkOption[0])) {
                    long fileSize = Files.size(target);
                    if (fileSize == size) continue;
                    this.logger.warn("File {} corrupted. Size {}, expected {}", (Object)target, (Object)size, (Object)fileSize);
                }
                toDownload.add(new AsyncDownloader.SizedFile((String)hash, path, size));
            }
            this.logger.info("Download {} files", (Object)toDownload.size());
            Downloader downloader = this.downloadWithProgressBar(dirName, toDownload, RESOURCES_DOWNLOAD_URL, assetDir);
            downloader.getFuture().get();
        } else {
            this.logger.info("Downloading asset, it may take some time");
            this.server.mirrorManager.downloadZip(assetDir, "assets/%s.zip", versionName);
        }
        this.server.syncUpdatesDir(Collections.singleton(dirName));
        this.logger.info("Asset successfully downloaded: '{}'", (Object)dirName);
    }

    public record MinecraftVersions(List<MiniVersionInfo> versions) {
    }

    public record MiniVersionInfo(String id, String url) {
    }

    public record MiniVersion(MinecraftAssetIndexInfo assetIndex) {
    }

    public record MinecraftAssetIndexInfo(String id, String url) {
    }
}

