/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.util.PrivateKeyFactory;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;

public class CertificateManager {
    private final transient Logger logger = LogManager.getLogger();
    public LauncherTrustManager trustManager;

    public void writePrivateKey(Path file, PrivateKey privateKey) throws IOException {
        this.writePrivateKey((Writer)IOHelper.newWriter((Path)file), privateKey);
    }

    public void writePrivateKey(Writer writer, PrivateKey privateKey) throws IOException {
        try (PemWriter writer1 = new PemWriter(writer);){
            writer1.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", privateKey.getEncoded()));
        }
    }

    public void writePrivateKey(Path file, AsymmetricKeyParameter key) throws IOException {
        this.writePrivateKey((Writer)IOHelper.newWriter((Path)file), key);
    }

    public void writePrivateKey(Writer writer, AsymmetricKeyParameter key) throws IOException {
        PrivateKeyInfo info = PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)key);
        try (PemWriter writer1 = new PemWriter(writer);){
            writer1.writeObject((PemObjectGenerator)new PemObject("PRIVATE KEY", info.getEncoded()));
        }
    }

    public void writeCertificate(Path file, X509CertificateHolder holder) throws IOException {
        this.writeCertificate(IOHelper.newWriter((Path)file), holder);
    }

    public void writeCertificate(Writer writer, X509CertificateHolder holder) throws IOException {
        try (PemWriter writer1 = new PemWriter(writer);){
            writer1.writeObject((PemObjectGenerator)new PemObject("CERTIFICATE", holder.toASN1Structure().getEncoded()));
        }
    }

    public AsymmetricKeyParameter readPrivateKey(Path file) throws IOException {
        return this.readPrivateKey(IOHelper.newReader((Path)file));
    }

    public AsymmetricKeyParameter readPrivateKey(Reader reader) throws IOException {
        AsymmetricKeyParameter ret;
        try (PemReader reader1 = new PemReader(reader);){
            byte[] bytes = reader1.readPemObject().getContent();
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);){
                ret = PrivateKeyFactory.createKey((InputStream)inputStream);
            }
        }
        return ret;
    }

    public X509CertificateHolder readCertificate(Path file) throws IOException {
        return this.readCertificate(IOHelper.newReader((Path)file));
    }

    public X509CertificateHolder readCertificate(Reader reader) throws IOException {
        X509CertificateHolder ret;
        try (PemReader reader1 = new PemReader(reader);){
            byte[] bytes = reader1.readPemObject().getContent();
            ret = new X509CertificateHolder(bytes);
        }
        return ret;
    }

    public void readTrustStore(Path dir) throws IOException, CertificateException {
        if (!IOHelper.isDir((Path)dir)) {
            Files.createDirectories(dir, new FileAttribute[0]);
            try {
                URL inBuildCert = IOHelper.getResourceURL((String)"pro/gravit/launchserver/defaults/BuildCertificate.crt");
                try (OutputStream outputStream = IOHelper.newOutput((Path)dir.resolve("BuildCertificate.crt"));
                     InputStream inputStream = IOHelper.newInput((URL)inBuildCert);){
                    IOHelper.transfer((InputStream)inputStream, (OutputStream)outputStream);
                }
            }
            catch (NoSuchFileException inBuildCert) {}
        } else if (IOHelper.exists((Path)dir.resolve("GravitCentralRootCA.crt"))) {
            this.logger.warn("Found old default certificate - 'GravitCentralRootCA.crt'. Delete...");
            Files.delete(dir.resolve("GravitCentralRootCA.crt"));
        }
        final ArrayList certificates = new ArrayList();
        final CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        IOHelper.walk((Path)dir, (FileVisitor)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (file.toFile().getName().endsWith(".crt")) {
                    try (InputStream inputStream = IOHelper.newInput((Path)file);){
                        certificates.add((X509Certificate)certFactory.generateCertificate(inputStream));
                    }
                    catch (CertificateException e) {
                        throw new IOException(e);
                    }
                }
                return super.visitFile(file, attrs);
            }
        }, (boolean)false);
        this.trustManager = new LauncherTrustManager(certificates.toArray(new X509Certificate[0]));
    }

    public LauncherTrustManager.CheckClassResult checkClass(Class<?> clazz) {
        X509Certificate[] certificates = JVMHelper.getCertificates(clazz);
        return this.trustManager.checkCertificates(certificates, (arg_0, arg_1, arg_2) -> ((LauncherTrustManager)this.trustManager).stdCertificateChecker(arg_0, arg_1, arg_2));
    }
}

