/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket;

import com.google.gson.Gson;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.concurrent.GenericFutureListener;
import java.lang.reflect.Type;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.function.BiConsumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.events.request.ErrorRequestEvent;
import pro.gravit.launcher.events.request.ExitRequestEvent;
import pro.gravit.launcher.request.WebSocketEvent;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.handlers.WebSocketFrameHandler;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.WebSocketServerResponse;
import pro.gravit.launchserver.socket.response.auth.AdditionalDataResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.CheckServerResponse;
import pro.gravit.launchserver.socket.response.auth.CurrentUserResponse;
import pro.gravit.launchserver.socket.response.auth.ExitResponse;
import pro.gravit.launchserver.socket.response.auth.FetchClientProfileKeyResponse;
import pro.gravit.launchserver.socket.response.auth.GetAvailabilityAuthResponse;
import pro.gravit.launchserver.socket.response.auth.JoinServerResponse;
import pro.gravit.launchserver.socket.response.auth.ProfilesResponse;
import pro.gravit.launchserver.socket.response.auth.RefreshTokenResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreSessionResponse;
import pro.gravit.launchserver.socket.response.auth.SetProfileResponse;
import pro.gravit.launchserver.socket.response.management.FeaturesResponse;
import pro.gravit.launchserver.socket.response.management.GetPublicKeyResponse;
import pro.gravit.launchserver.socket.response.profile.BatchProfileByUsername;
import pro.gravit.launchserver.socket.response.profile.ProfileByUUIDResponse;
import pro.gravit.launchserver.socket.response.profile.ProfileByUsername;
import pro.gravit.launchserver.socket.response.secure.GetSecureLevelInfoResponse;
import pro.gravit.launchserver.socket.response.secure.HardwareReportResponse;
import pro.gravit.launchserver.socket.response.secure.SecurityReportResponse;
import pro.gravit.launchserver.socket.response.secure.VerifySecureLevelKeyResponse;
import pro.gravit.launchserver.socket.response.update.LauncherResponse;
import pro.gravit.launchserver.socket.response.update.UpdateListResponse;
import pro.gravit.launchserver.socket.response.update.UpdateResponse;
import pro.gravit.utils.BiHookSet;
import pro.gravit.utils.HookSet;
import pro.gravit.utils.ProviderMap;
import pro.gravit.utils.helper.IOHelper;

public class WebSocketService {
    public static final ProviderMap<WebSocketServerResponse> providers = new ProviderMap();
    public final ChannelGroup channels;
    public final HookSet<WebSocketRequestContext> hookBeforeParsing = new HookSet();
    public final HookSet<WebSocketRequestContext> hookBeforeExecute = new HookSet();
    public final HookSet<WebSocketRequestContext> hookComplete = new HookSet();
    public final BiHookSet<Channel, Object> hookSend = new BiHookSet();
    private final LaunchServer server;
    private final Gson gson;
    private final transient Logger logger = LogManager.getLogger();

    public WebSocketService(ChannelGroup channels, LaunchServer server) {
        this.channels = channels;
        this.server = server;
        this.gson = Launcher.gsonManager.gson;
    }

    public static void registerResponses() {
        providers.register("auth", AuthResponse.class);
        providers.register("checkServer", CheckServerResponse.class);
        providers.register("joinServer", JoinServerResponse.class);
        providers.register("profiles", ProfilesResponse.class);
        providers.register("launcher", LauncherResponse.class);
        providers.register("updateList", UpdateListResponse.class);
        providers.register("setProfile", SetProfileResponse.class);
        providers.register("update", UpdateResponse.class);
        providers.register("restoreSession", RestoreSessionResponse.class);
        providers.register("batchProfileByUsername", BatchProfileByUsername.class);
        providers.register("profileByUsername", ProfileByUsername.class);
        providers.register("profileByUUID", ProfileByUUIDResponse.class);
        providers.register("getAvailabilityAuth", GetAvailabilityAuthResponse.class);
        providers.register("exit", ExitResponse.class);
        providers.register("getSecureLevelInfo", GetSecureLevelInfoResponse.class);
        providers.register("verifySecureLevelKey", VerifySecureLevelKeyResponse.class);
        providers.register("securityReport", SecurityReportResponse.class);
        providers.register("hardwareReport", HardwareReportResponse.class);
        providers.register("currentUser", CurrentUserResponse.class);
        providers.register("features", FeaturesResponse.class);
        providers.register("refreshToken", RefreshTokenResponse.class);
        providers.register("restore", RestoreResponse.class);
        providers.register("additionalData", AdditionalDataResponse.class);
        providers.register("clientProfileKey", FetchClientProfileKeyResponse.class);
        providers.register("getPublicKey", GetPublicKeyResponse.class);
    }

    public static String getIPFromContext(ChannelHandlerContext ctx) {
        WebSocketFrameHandler handler = (WebSocketFrameHandler)ctx.pipeline().get(WebSocketFrameHandler.class);
        if (handler == null || handler.context == null || handler.context.ip == null) {
            return IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress());
        }
        return handler.context.ip;
    }

    public static String getIPFromChannel(Channel channel) {
        WebSocketFrameHandler handler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class);
        if (handler == null || handler.context == null || handler.context.ip == null) {
            return IOHelper.getIP((SocketAddress)channel.remoteAddress());
        }
        return handler.context.ip;
    }

    public void forEachActiveChannels(BiConsumer<Channel, WebSocketFrameHandler> callback) {
        for (Channel channel : this.channels) {
            WebSocketFrameHandler wsHandler;
            if (channel == null || channel.pipeline() == null || (wsHandler = (WebSocketFrameHandler)channel.pipeline().get(WebSocketFrameHandler.class)) == null) continue;
            callback.accept(channel, wsHandler);
        }
    }

    public void process(ChannelHandlerContext ctx, TextWebSocketFrame frame, Client client, String ip) {
        WebSocketServerResponse response;
        String request = frame.text();
        WebSocketRequestContext context = new WebSocketRequestContext(ctx, request, client, ip);
        if (this.hookBeforeParsing.hook((Object)context)) {
            return;
        }
        context.response = response = (WebSocketServerResponse)this.gson.fromJson(request, WebSocketServerResponse.class);
        if (response == null) {
            ErrorRequestEvent event = new ErrorRequestEvent("This type of request is not supported");
            this.hookComplete.hook((Object)context);
            this.sendObject(ctx.channel(), event, (Type)((Object)WebSocketEvent.class));
            return;
        }
        this.process(context, response, client, ip);
    }

    void process(WebSocketRequestContext context, WebSocketServerResponse response, Client client, String ip) {
        if (this.hookBeforeExecute.hook((Object)context)) {
            return;
        }
        ChannelHandlerContext ctx = context.context;
        if (response instanceof SimpleResponse) {
            SimpleResponse simpleResponse = (SimpleResponse)response;
            simpleResponse.server = this.server;
            simpleResponse.service = this;
            simpleResponse.ctx = ctx;
            simpleResponse.ip = ip != null ? ip : IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress());
        }
        try {
            response.execute(ctx, client);
        }
        catch (Throwable e) {
            context.exception = e;
            this.logger.error("WebSocket request processing failed", e);
            ErrorRequestEvent event = new ErrorRequestEvent("Fatal server error. Contact administrator");
            if (response instanceof SimpleResponse) {
                SimpleResponse simpleResponse = (SimpleResponse)response;
                event.requestUUID = simpleResponse.requestUUID;
            }
            this.sendObject(ctx.channel(), event);
        }
        this.hookComplete.hook((Object)context);
    }

    public void registerClient(Channel channel) {
        this.channels.add((Object)channel);
    }

    public void sendObject(Channel channel, Object obj) {
        if (this.hookSend.hook((Object)channel, obj)) {
            return;
        }
        String msg = this.gson.toJson(obj, WebSocketEvent.class);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Send to channel {}: {}", (Object)WebSocketService.getIPFromChannel(channel), (Object)msg);
        }
        channel.writeAndFlush((Object)new TextWebSocketFrame(msg), channel.voidPromise());
    }

    public void sendObject(Channel channel, Object obj, Type type) {
        if (this.hookSend.hook((Object)channel, obj)) {
            return;
        }
        String msg = this.gson.toJson(obj, type);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Send to channel {}: {}", (Object)WebSocketService.getIPFromChannel(channel), (Object)msg);
        }
        channel.writeAndFlush((Object)new TextWebSocketFrame(msg), channel.voidPromise());
    }

    public void sendObjectAll(Object obj, Type type) {
        for (Channel ch : this.channels) {
            this.sendObject(ch, obj, type);
        }
    }

    public void sendObjectToUUID(UUID userUuid, Object obj, Type type) {
        for (Channel ch : this.channels) {
            Client client;
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || (client = wsHandler.getClient()) == null || !userUuid.equals(client.uuid) || this.hookSend.hook((Object)ch, obj)) continue;
            String msg = this.gson.toJson(obj, type);
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Send to {}({}): {}", (Object)WebSocketService.getIPFromChannel(ch), (Object)userUuid, (Object)msg);
            }
            ch.writeAndFlush((Object)new TextWebSocketFrame(msg), ch.voidPromise());
        }
    }

    public Channel getChannelFromConnectUUID(UUID connectUuid) {
        for (Channel ch : this.channels) {
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || !connectUuid.equals(wsHandler.getConnectUUID())) continue;
            return ch;
        }
        return null;
    }

    public boolean kickByUserUUID(UUID userUuid, boolean isClose) {
        boolean result = false;
        for (Channel ch : this.channels) {
            Client client;
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || (client = wsHandler.getClient()) == null || !userUuid.equals(client.uuid)) continue;
            ExitResponse.exit(this.server, wsHandler, ch, ExitRequestEvent.ExitReason.SERVER);
            if (isClose) {
                ch.close();
            }
            result = true;
        }
        return result;
    }

    public boolean kickByConnectUUID(UUID connectUuid, boolean isClose) {
        for (Channel ch : this.channels) {
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || !connectUuid.equals(wsHandler.getConnectUUID())) continue;
            ExitResponse.exit(this.server, wsHandler, ch, ExitRequestEvent.ExitReason.SERVER);
            if (isClose) {
                ch.close();
            }
            return true;
        }
        return false;
    }

    public boolean kickByIP(String ip, boolean isClose) {
        boolean result = false;
        for (Channel ch : this.channels) {
            String clientIp;
            WebSocketFrameHandler wsHandler;
            if (ch == null || ch.pipeline() == null || (wsHandler = (WebSocketFrameHandler)ch.pipeline().get(WebSocketFrameHandler.class)) == null || !ip.equals(clientIp = wsHandler.context != null && wsHandler.context.ip != null ? wsHandler.context.ip : IOHelper.getIP((SocketAddress)ch.remoteAddress()))) continue;
            ExitResponse.exit(this.server, wsHandler, ch, ExitRequestEvent.ExitReason.SERVER);
            if (isClose) {
                ch.close();
            }
            result = true;
        }
        return result;
    }

    public void sendObjectAndClose(ChannelHandlerContext ctx, Object obj) {
        if (this.hookSend.hook((Object)ctx.channel(), obj)) {
            return;
        }
        String msg = this.gson.toJson(obj, WebSocketEvent.class);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Send and close {}: {}", (Object)WebSocketService.getIPFromContext(ctx), (Object)msg);
        }
        ctx.writeAndFlush((Object)new TextWebSocketFrame(msg)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void sendObjectAndClose(ChannelHandlerContext ctx, Object obj, Type type) {
        if (this.hookSend.hook((Object)ctx.channel(), obj)) {
            return;
        }
        String msg = this.gson.toJson(obj, type);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Send and close {}: {}", (Object)WebSocketService.getIPFromContext(ctx), (Object)msg);
        }
        ctx.writeAndFlush((Object)new TextWebSocketFrame(msg)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public static class WebSocketRequestContext {
        public final ChannelHandlerContext context;
        public final String text;
        public final Client client;
        public final String ip;
        public WebSocketServerResponse response;
        public Throwable exception;

        public WebSocketRequestContext(ChannelHandlerContext context, String text, Client client, String ip) {
            this.context = context;
            this.text = text;
            this.client = client;
            this.ip = ip;
        }
    }

    public static class EventResult
    implements WebSocketEvent {
        public String getType() {
            return "event";
        }
    }
}

