/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.handlers;

import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.SocketAddress;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.NettyConnectContext;
import pro.gravit.launchserver.socket.WebSocketService;
import pro.gravit.utils.BiHookSet;
import pro.gravit.utils.helper.IOHelper;

public class WebSocketFrameHandler
extends SimpleChannelInboundHandler<WebSocketFrame> {
    public final LaunchServer srv;
    public final WebSocketService service;
    public final BiHookSet<ChannelHandlerContext, WebSocketFrame> hooks = new BiHookSet();
    private final UUID connectUUID = UUID.randomUUID();
    private final transient Logger logger = LogManager.getLogger();
    public NettyConnectContext context;
    private Client client;
    private ScheduledFuture<?> future;

    public WebSocketFrameHandler(NettyConnectContext context, LaunchServer srv, WebSocketService service) {
        this.context = context;
        this.srv = srv;
        this.service = service;
    }

    public Client getClient() {
        return this.client;
    }

    public void setClient(Client client) {
        this.client = client;
    }

    public final UUID getConnectUUID() {
        return this.connectUUID;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.logger.trace("New client {}", (Object)IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress()));
        this.client = new Client();
        Channel ch = ctx.channel();
        this.service.registerClient(ch);
        this.future = ctx.executor().scheduleAtFixedRate(() -> ch.writeAndFlush((Object)new PingWebSocketFrame(), ch.voidPromise()), 30L, 30L, TimeUnit.SECONDS);
    }

    protected void channelRead0(ChannelHandlerContext ctx, WebSocketFrame frame) {
        try {
            if (this.hooks.hook((Object)ctx, (Object)frame)) {
                return;
            }
        }
        catch (Throwable ex) {
            this.logger.error("WebSocket frame handler hook error", ex);
        }
        if (frame instanceof TextWebSocketFrame) {
            TextWebSocketFrame textWebSocketFrame = (TextWebSocketFrame)frame;
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("Message from {}: {}", (Object)(this.context.ip == null ? IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress()) : this.context.ip), (Object)textWebSocketFrame.text());
            }
            try {
                this.service.process(ctx, textWebSocketFrame, this.client, this.context.ip);
            }
            catch (Throwable ex) {
                this.logger.warn("Client {} send invalid request. Connection force closed.", (Object)(this.context.ip == null ? IOHelper.getIP((SocketAddress)ctx.channel().remoteAddress()) : this.context.ip));
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Client message: {}", (Object)textWebSocketFrame.text());
                    this.logger.error("Process websockets request failed", ex);
                }
                ctx.channel().close();
            }
        } else if (frame instanceof PingWebSocketFrame) {
            frame.content().retain();
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(frame.content()));
        } else if (frame instanceof PongWebSocketFrame) {
            this.logger.trace("WebSocket Client received pong");
        } else if (frame instanceof CloseWebSocketFrame) {
            CloseWebSocketFrame closeWebSocketFrame = (CloseWebSocketFrame)frame;
            int statusCode = closeWebSocketFrame.statusCode();
            ctx.channel().close();
        } else {
            String message = "unsupported frame type: " + frame.getClass().getName();
            this.logger.error((Object)new UnsupportedOperationException(message));
        }
    }

    public void channelInactive(ChannelHandlerContext channelHandlerContext) throws Exception {
        if (this.future != null) {
            this.future.cancel(true);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("Client {} disconnected", (Object)IOHelper.getIP((SocketAddress)channelHandlerContext.channel().remoteAddress()));
        }
        super.channelInactive(channelHandlerContext);
    }
}

