/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.Feature;
import pro.gravit.launchserver.auth.Features;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;

public final class AuthProviderPair {
    private final transient Logger logger = LogManager.getLogger();
    public boolean isDefault = true;
    public AuthCoreProvider core;
    public TextureProvider textureProvider;
    public Map<String, String> links;
    public transient String name;
    public transient Set<String> features;
    public String displayName;
    public boolean visible = true;

    public AuthProviderPair() {
    }

    public AuthProviderPair(AuthCoreProvider core, TextureProvider textureProvider) {
        this.core = core;
        this.textureProvider = textureProvider;
    }

    public static Set<String> getFeatures(Class<?> clazz) {
        HashSet<String> list = new HashSet<String>();
        AuthProviderPair.getFeatures(clazz, list);
        return list;
    }

    public static void getFeatures(Class<?> clazz, Set<String> list) {
        Class<?>[] interfaces;
        Class<?> superClass;
        Features features = clazz.getAnnotation(Features.class);
        if (features != null) {
            for (Feature feature : features.value()) {
                list.add(feature.value());
            }
        }
        if ((superClass = clazz.getSuperclass()) != null && superClass != Object.class) {
            AuthProviderPair.getFeatures(superClass, list);
        }
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            AuthProviderPair.getFeatures(i, list);
        }
    }

    public final <T> T isSupport(Class<T> clazz) {
        if (this.core == null) {
            return null;
        }
        T result = null;
        if (result == null) {
            result = this.core.isSupport(clazz);
        }
        return result;
    }

    public final void init(LaunchServer srv, String name) {
        this.name = name;
        if (this.links != null) {
            this.link(srv);
        }
        this.core.init(srv);
        this.features = new HashSet<String>();
        AuthProviderPair.getFeatures(this.core.getClass(), this.features);
    }

    public final void link(LaunchServer srv) {
        this.links.forEach((k, v) -> {
            AuthProviderPair pair = srv.config.getAuthProviderPair((String)v);
            if (pair == null) {
                throw new NullPointerException("Auth %s link failed. Pair %s not found".formatted(this.name, v));
            }
            if ("core".equals(k)) {
                if (pair.core == null) {
                    throw new NullPointerException("Auth %s link failed. %s.core is null".formatted(this.name, v));
                }
                this.core = pair.core;
            }
        });
    }

    public final void close() throws IOException {
        this.core.close();
        if (this.textureProvider != null) {
            this.textureProvider.close();
        }
    }
}

