/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.FetchClientProfileKeyRequestEvent;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.session.UserSessionSupportKeys;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class FetchClientProfileKeyResponse
extends SimpleResponse {
    @Override
    public String getType() {
        return "clientProfileKey";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        UserSessionSupportKeys.ClientProfileKeys keys;
        if (!client.isAuth || client.type != AuthResponse.ConnectTypes.CLIENT) {
            this.sendError("Permissions denied");
            return;
        }
        UserSession session = client.sessionObject;
        if (session instanceof UserSessionSupportKeys) {
            UserSessionSupportKeys support = (UserSessionSupportKeys)((Object)session);
            keys = support.getClientProfileKeys();
        } else {
            keys = this.server.authManager.createClientProfileKeys(client.uuid);
        }
        this.sendResult((RequestEvent)new FetchClientProfileKeyRequestEvent(keys.publicKey(), keys.privateKey(), keys.signature(), keys.expiresAt(), keys.refreshedAfter()));
    }
}

