/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.AuthRequestEvent;
import pro.gravit.launcher.events.request.RefreshTokenRequestEvent;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;

public class RefreshTokenResponse
extends SimpleResponse {
    public String authId;
    public String refreshToken;

    @Override
    public String getType() {
        return "refreshToken";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        if (this.refreshToken == null) {
            this.sendError("Invalid request");
            return;
        }
        AuthProviderPair pair = !client.isAuth ? (this.authId == null ? this.server.config.getAuthProviderPair() : this.server.config.getAuthProviderPair(this.authId)) : client.auth;
        if (pair == null) {
            this.sendError("Invalid request");
            return;
        }
        AuthManager.AuthReport report = pair.core.refreshAccessToken(this.refreshToken, new AuthResponse.AuthContext(client, null, null, this.ip, AuthResponse.ConnectTypes.API, pair));
        if (report == null || !report.isUsingOAuth()) {
            this.sendError("Invalid RefreshToken");
            return;
        }
        this.sendResult((RequestEvent)new RefreshTokenRequestEvent(new AuthRequestEvent.OAuthRequestEvent(report.oauthAccessToken(), report.oauthRefreshToken(), report.oauthExpire())));
    }
}

