/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.modules;

import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.LauncherTrustManager;
import pro.gravit.launcher.modules.LauncherModule;
import pro.gravit.launcher.modules.LauncherModuleInfo;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.launchermodules.LauncherModuleLoader;

public class ModulesCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public ModulesCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return null;
    }

    public String getUsageDescription() {
        return "get all modules";
    }

    public void invoke(String ... args) {
        for (LauncherModule module : this.server.modulesManager.getModules()) {
            LauncherModuleInfo info = module.getModuleInfo();
            LauncherTrustManager.CheckClassResult checkStatus = module.getCheckResult();
            this.logger.info("[MODULE] {} v: {} p: {} deps: {} sig: {}", (Object)info.name, (Object)info.version.getVersionString(), (Object)info.priority, (Object)Arrays.toString(info.dependencies), (Object)(checkStatus == null ? "null" : checkStatus.type));
            this.printCheckStatusInfo(checkStatus);
        }
        for (LauncherModuleLoader.ModuleEntity entity : this.server.launcherModuleLoader.launcherModules) {
            LauncherTrustManager.CheckClassResult checkStatus = entity.checkResult;
            this.logger.info("[LAUNCHER MODULE] {} sig: {}", (Object)entity.path.getFileName().toString(), (Object)(checkStatus == null ? "null" : checkStatus.type));
            this.printCheckStatusInfo(checkStatus);
        }
    }

    private void printCheckStatusInfo(LauncherTrustManager.CheckClassResult checkStatus) {
        X509Certificate cert;
        if (checkStatus != null && checkStatus.endCertificate != null) {
            cert = checkStatus.endCertificate;
            this.logger.info("[MODULE CERT] Module signer: {}", (Object)cert.getSubjectX500Principal().getName());
        }
        if (checkStatus != null && checkStatus.rootCertificate != null) {
            cert = checkStatus.rootCertificate;
            this.logger.info("[MODULE CERT] Module signer CA: {}", (Object)cert.getSubjectX500Principal().getName());
        }
    }
}

