/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth.core;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.events.request.GetAvailabilityAuthRequestEvent;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.details.AuthLoginOnlyDetails;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.utils.helper.SecurityHelper;

public class MemoryAuthCoreProvider
extends AuthCoreProvider {
    private final transient List<MemoryUser> memory = new ArrayList<MemoryUser>(16);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUserByUsername(String username) {
        List<MemoryUser> list = this.memory;
        synchronized (list) {
            for (MemoryUser u : this.memory) {
                if (!u.username.equals(username)) continue;
                return u;
            }
            MemoryUser result = new MemoryUser(username);
            this.memory.add(result);
            return result;
        }
    }

    @Override
    public List<GetAvailabilityAuthRequestEvent.AuthAvailabilityDetails> getDetails(Client client) {
        return List.of(new AuthLoginOnlyDetails());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User getUserByUUID(UUID uuid) {
        List<MemoryUser> list = this.memory;
        synchronized (list) {
            for (MemoryUser u : this.memory) {
                if (!u.uuid.equals(uuid)) continue;
                return u;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UserSession getUserSessionByOAuthAccessToken(String accessToken) {
        List<MemoryUser> list = this.memory;
        synchronized (list) {
            for (MemoryUser u : this.memory) {
                if (!u.accessToken.equals(accessToken)) continue;
                return new MemoryUserSession(u);
            }
        }
        return null;
    }

    @Override
    public AuthManager.AuthReport refreshAccessToken(String refreshToken, AuthResponse.AuthContext context) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthManager.AuthReport authorize(String login, AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password, boolean minecraftAccess) throws IOException {
        if (login == null) {
            throw AuthException.userNotFound();
        }
        MemoryUser user = null;
        List<MemoryUser> list = this.memory;
        synchronized (list) {
            for (MemoryUser u : this.memory) {
                if (!u.username.equals(login)) continue;
                user = u;
                break;
            }
            if (user == null) {
                user = new MemoryUser(login);
                this.memory.add(user);
            }
        }
        if (!minecraftAccess) {
            return AuthManager.AuthReport.ofOAuth(user.accessToken, null, 0L, new MemoryUserSession(user));
        }
        return AuthManager.AuthReport.ofOAuthWithMinecraft(user.accessToken, user.accessToken, null, 0L, new MemoryUserSession(user));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public User checkServer(Client client, String username, String serverID) {
        List<MemoryUser> list = this.memory;
        synchronized (list) {
            for (MemoryUser u : this.memory) {
                if (!u.username.equals(username)) continue;
                return u;
            }
            MemoryUser result = new MemoryUser(username);
            this.memory.add(result);
            return result;
        }
    }

    @Override
    public boolean joinServer(Client client, String username, UUID uuid, String accessToken, String serverID) {
        return true;
    }

    @Override
    public void init(LaunchServer server) {
    }

    @Override
    public void close() {
    }

    public static class MemoryUser
    implements User {
        private final String username;
        private final UUID uuid;
        private String serverId;
        private final String accessToken;
        private final ClientPermissions permissions;

        public MemoryUser(String username) {
            this.username = username;
            this.uuid = MemoryUser.makeUuidFromUsername(username);
            this.accessToken = SecurityHelper.randomStringToken();
            this.permissions = new ClientPermissions();
        }

        private static UUID makeUuidFromUsername(String username) {
            return UUID.nameUUIDFromBytes(username.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public String getUsername() {
            return this.username;
        }

        @Override
        public UUID getUUID() {
            return this.uuid;
        }

        @Override
        public ClientPermissions getPermissions() {
            return this.permissions;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MemoryUser that = (MemoryUser)o;
            return this.uuid.equals(that.uuid);
        }

        public int hashCode() {
            return Objects.hash(this.uuid);
        }
    }

    public static class MemoryUserSession
    implements UserSession {
        private final String id = SecurityHelper.randomStringToken();
        private final MemoryUser user;
        private final long expireIn;

        public MemoryUserSession(MemoryUser user) {
            this.user = user;
            this.expireIn = 0L;
        }

        @Override
        public String getID() {
            return this.id;
        }

        @Override
        public User getUser() {
            return this.user;
        }

        @Override
        public String getMinecraftAccessToken() {
            return "IGNORED";
        }

        @Override
        public long getExpireIn() {
            return this.expireIn;
        }
    }
}

