/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.basic;

import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;

public class DebugCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public DebugCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[true/false]";
    }

    public String getUsageDescription() {
        return "Enable log level TRACE in LaunchServer";
    }

    public void invoke(String ... args) throws Exception {
        this.verifyArgs(args, 1);
        boolean value = Boolean.parseBoolean(args[0]);
        LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig("pro.gravit");
        loggerConfig.setLevel(value ? Level.TRACE : Level.DEBUG);
        ctx.updateLoggers();
        if (value) {
            this.logger.info("Log level TRACE enabled");
        } else {
            this.logger.info("Log level TRACE disabled");
        }
    }
}

