/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.helper;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.security.Key;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.UUID;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.utils.helper.SecurityHelper;

public class LegacySessionHelper {
    public static String makeAccessJwtTokenFromString(User user, LocalDateTime expirationTime, ECPrivateKey privateKey) {
        return Jwts.builder().setIssuer("LaunchServer").setSubject(user.getUsername()).claim("uuid", (Object)user.getUUID().toString()).setExpiration(Date.from(expirationTime.toInstant(ZoneOffset.UTC))).signWith((Key)privateKey).compact();
    }

    public static JwtTokenInfo getJwtInfoFromAccessToken(String token, ECPublicKey publicKey) {
        JwtParser parser = Jwts.parserBuilder().requireIssuer("LaunchServer").setClock(() -> new Date(Clock.systemUTC().millis())).setSigningKey((Key)publicKey).build();
        Jws claims = parser.parseClaimsJws(token);
        UUID uuid = UUID.fromString((String)((Claims)claims.getBody()).get("uuid", String.class));
        String username = ((Claims)claims.getBody()).getSubject();
        return new JwtTokenInfo(username, uuid);
    }

    public static String makeRefreshTokenFromPassword(String username, String rawPassword, String secretSalt) {
        if (rawPassword == null) {
            rawPassword = "";
        }
        return SecurityHelper.toHex((byte[])SecurityHelper.digest((SecurityHelper.DigestAlgorithm)SecurityHelper.DigestAlgorithm.SHA256, (String)"%s.%s.%s.%s".formatted(secretSalt, username, rawPassword, secretSalt)));
    }

    public record JwtTokenInfo(String username, UUID uuid) {
    }
}

