/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.auth;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.Feature;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.mix.MixProvider;
import pro.gravit.launchserver.auth.texture.TextureProvider;

public final class AuthProviderPair {
    private final transient Logger logger = LogManager.getLogger();
    public boolean isDefault = true;
    public AuthCoreProvider core;
    public TextureProvider textureProvider;
    public Map<String, MixProvider> mixes;
    public Map<String, String> links;
    public transient String name;
    public transient Set<String> features;
    public String displayName;
    public boolean visible = true;

    public AuthProviderPair() {
    }

    public AuthProviderPair(AuthCoreProvider core, TextureProvider textureProvider) {
        this.core = core;
        this.textureProvider = textureProvider;
    }

    public static Set<String> getFeatures(Class<?> clazz) {
        HashSet<String> list = new HashSet<String>();
        AuthProviderPair.getFeatures(clazz, list);
        return list;
    }

    public Set<String> getFeatures() {
        return this.features;
    }

    public static void getFeatures(Class<?> clazz, Set<String> list) {
        Class<?>[] interfaces;
        Feature[] features;
        for (Feature feature : features = (Feature[])clazz.getAnnotationsByType(Feature.class)) {
            list.add(feature.value());
        }
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && superClass != Object.class) {
            AuthProviderPair.getFeatures(superClass, list);
        }
        for (Class<?> i : interfaces = clazz.getInterfaces()) {
            AuthProviderPair.getFeatures(i, list);
        }
    }

    public final <T> T isSupport(Class<T> clazz) {
        T result;
        block2: {
            MixProvider m;
            if (this.core == null) {
                return null;
            }
            result = this.core.isSupport(clazz);
            if (result != null || this.mixes == null) break block2;
            Iterator<MixProvider> iterator = this.mixes.values().iterator();
            while (iterator.hasNext() && (result = (m = iterator.next()).isSupport(clazz)) == null) {
            }
        }
        return result;
    }

    public final void init(LaunchServer srv, String name) {
        this.name = name;
        if (this.links != null) {
            this.link(srv);
        }
        this.core.init(srv);
        this.features = new HashSet<String>();
        AuthProviderPair.getFeatures(this.core.getClass(), this.features);
        if (this.mixes != null) {
            for (MixProvider m : this.mixes.values()) {
                m.init(srv, this.core);
                AuthProviderPair.getFeatures(m.getClass(), this.features);
            }
        }
    }

    public final void link(LaunchServer srv) {
        this.links.forEach((k, v) -> {
            AuthProviderPair pair = srv.config.getAuthProviderPair((String)v);
            if (pair == null) {
                throw new NullPointerException("Auth %s link failed. Pair %s not found".formatted(this.name, v));
            }
            if ("core".equals(k)) {
                if (pair.core == null) {
                    throw new NullPointerException("Auth %s link failed. %s.core is null".formatted(this.name, v));
                }
                this.core = pair.core;
            }
        });
    }

    public final void close() throws IOException {
        this.core.close();
        if (this.textureProvider != null) {
            this.textureProvider.close();
        }
        if (this.mixes != null) {
            for (MixProvider m : this.mixes.values()) {
                m.close();
            }
        }
    }
}

