/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.command.hash;

import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collections;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.ClientProfileVersions;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.command.Command;
import pro.gravit.launchserver.helper.MakeProfileHelper;
import pro.gravit.utils.command.CommandException;
import pro.gravit.utils.helper.IOHelper;

public final class DownloadClientCommand
extends Command {
    private final transient Logger logger = LogManager.getLogger();

    public DownloadClientCommand(LaunchServer server) {
        super(server);
    }

    public String getArgsDescription() {
        return "[version] [dir] (mirror/generate)";
    }

    public String getUsageDescription() {
        return "Download client dir";
    }

    public void invoke(String ... args) throws IOException, CommandException {
        this.verifyArgs(args, 2);
        String versionName = args[0];
        String dirName = IOHelper.verifyFileName((String)(args[1] != null ? args[1] : args[0]));
        Path clientDir = this.server.updatesDir.resolve(dirName);
        boolean isMirrorClientDownload = false;
        if (args.length > 2) {
            isMirrorClientDownload = args[2].equals("mirror");
        }
        this.logger.info("Downloading client, it may take some time");
        this.server.mirrorManager.downloadZip(clientDir, "clients/%s.zip", versionName);
        this.logger.info("Creaing profile file: '{}'", (Object)dirName);
        ClientProfile clientProfile = null;
        if (isMirrorClientDownload) {
            try {
                ClientProfile.ServerProfile serverProfile;
                JsonElement clientJson = this.server.mirrorManager.jsonRequest(null, "GET", "clients/%s.json", versionName);
                clientProfile = (ClientProfile)Launcher.gsonManager.configGson.fromJson(clientJson, ClientProfile.class);
                clientProfile.setTitle(dirName);
                clientProfile.setDir(dirName);
                clientProfile.setUUID(UUID.randomUUID());
                if (clientProfile.getServers() != null && (serverProfile = clientProfile.getDefaultServerProfile()) != null) {
                    serverProfile.name = dirName;
                }
            }
            catch (Exception e) {
                this.logger.error("Filed download clientProfile from mirror: '{}' Generation through MakeProfileHelper", (Object)versionName);
                isMirrorClientDownload = false;
            }
        }
        if (!isMirrorClientDownload) {
            try {
                MakeProfileHelper.MakeProfileOption[] options;
                ClientProfile.Version version;
                String internalVersion = versionName;
                if (internalVersion.contains("-")) {
                    internalVersion = internalVersion.substring(0, versionName.indexOf(45));
                }
                if ((version = ClientProfile.Version.of((String)internalVersion)).compareTo(ClientProfileVersions.MINECRAFT_1_7_10) <= 0) {
                    this.logger.warn("Minecraft 1.7.9 and below not supported. Use at your own risk");
                }
                for (MakeProfileHelper.MakeProfileOption option : options = MakeProfileHelper.getMakeProfileOptionsFromDir(clientDir, version)) {
                    this.logger.debug("Detected option {}", (Object)option.getClass().getSimpleName());
                }
                clientProfile = MakeProfileHelper.makeProfile(version, dirName, options);
            }
            catch (Throwable e) {
                isMirrorClientDownload = true;
            }
        }
        try (BufferedWriter writer = IOHelper.newWriter((Path)IOHelper.resolveIncremental((Path)this.server.profilesDir, (String)dirName, (String)"json"));){
            Launcher.gsonManager.configGson.toJson(clientProfile, (Appendable)writer);
        }
        this.server.syncProfilesDir();
        this.server.syncUpdatesDir(Collections.singleton(dirName));
        this.logger.info("Client successfully downloaded: '{}'", (Object)dirName);
    }
}

