/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.helper;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.Launcher;
import pro.gravit.launcher.request.RequestException;

public final class HttpHelper {
    private static final Logger logger = LogManager.getLogger();

    private HttpHelper() {
        throw new UnsupportedOperationException();
    }

    public static <T, E> HttpOptional<T, E> send(HttpClient client, HttpRequest request, HttpErrorHandler<T, E> handler) throws IOException {
        try {
            HttpResponse<InputStream> response = client.send(request, HttpResponse.BodyHandlers.ofInputStream());
            return handler.apply(response);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public static <T, E> CompletableFuture<HttpOptional<T, E>> sendAsync(HttpClient client, HttpRequest request, HttpErrorHandler<T, E> handler) {
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofInputStream()).thenApply(handler::apply);
    }

    public static <T> HttpResponse.BodyHandler<T> ofJsonResult(Class<T> type) {
        return HttpHelper.ofJsonResult(type);
    }

    public static <T> HttpResponse.BodyHandler<T> ofJsonResult(Type type) {
        return new JsonBodyHandler<Object>(HttpResponse.BodyHandlers.ofInputStream(), input -> {
            Object object;
            InputStreamReader reader = new InputStreamReader((InputStream)input);
            try {
                object = Launcher.gsonManager.gson.fromJson((Reader)reader, type);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((Reader)reader).close();
            return object;
        });
    }

    public static <T> HttpRequest.BodyPublisher jsonBodyPublisher(T obj) {
        return HttpRequest.BodyPublishers.ofString(Launcher.gsonManager.gson.toJson(obj));
    }

    public static interface HttpErrorHandler<T, E> {
        public HttpOptional<T, E> apply(HttpResponse<InputStream> var1);
    }

    public static class HttpOptional<T, E> {
        protected final T result;
        protected final E error;
        protected final int statusCode;

        public HttpOptional(T result, E error, int statusCode) {
            this.result = result;
            this.error = error;
            this.statusCode = statusCode;
        }

        public T result() {
            return this.result;
        }

        public E error() {
            return this.error;
        }

        public int statusCode() {
            return this.statusCode;
        }

        public boolean isSuccessful() {
            return this.statusCode >= 200 && this.statusCode < 300;
        }

        public T getOrThrow() throws RequestException {
            if (this.isSuccessful()) {
                return this.result;
            }
            throw new RequestException(this.error == null ? "statusCode %d".formatted(this.statusCode) : this.error.toString());
        }
    }

    private static class JsonBodyHandler<T>
    implements HttpResponse.BodyHandler<T> {
        private final HttpResponse.BodyHandler<InputStream> delegate;
        private final Function<InputStream, T> func;

        private JsonBodyHandler(HttpResponse.BodyHandler<InputStream> delegate, Function<InputStream, T> func) {
            this.delegate = delegate;
            this.func = func;
        }

        @Override
        public HttpResponse.BodySubscriber<T> apply(HttpResponse.ResponseInfo responseInfo) {
            return new JsonBodySubscriber<T>(this.delegate.apply(responseInfo), this.func);
        }
    }

    private static class JsonBodySubscriber<T>
    implements HttpResponse.BodySubscriber<T> {
        private final HttpResponse.BodySubscriber<InputStream> delegate;
        private final Function<InputStream, T> func;

        private JsonBodySubscriber(HttpResponse.BodySubscriber<InputStream> delegate, Function<InputStream, T> func) {
            this.delegate = delegate;
            this.func = func;
        }

        @Override
        public CompletionStage<T> getBody() {
            return this.delegate.getBody().thenApply(this.func);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.delegate.onSubscribe(subscription);
        }

        @Override
        public void onNext(List<ByteBuffer> item) {
            this.delegate.onNext((InputStream)((Object)item));
        }

        @Override
        public void onError(Throwable throwable) {
            this.delegate.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.delegate.onComplete();
        }
    }

    public static final class BasicJsonHttpErrorHandler<T>
    implements HttpJsonErrorHandler<T, Void> {
        private final Class<T> type;

        public BasicJsonHttpErrorHandler(Class<T> type) {
            this.type = type;
        }

        @Override
        public HttpOptional<T, Void> applyJson(JsonElement response, int statusCode) {
            return new HttpOptional<Object, Object>(Launcher.gsonManager.gson.fromJson(response, this.type), null, statusCode);
        }
    }

    public static interface HttpJsonErrorHandler<T, E>
    extends HttpErrorHandler<T, E> {
        public HttpOptional<T, E> applyJson(JsonElement var1, int var2);

        @Override
        default public HttpOptional<T, E> apply(HttpResponse<InputStream> response) {
            HttpOptional<T, E> httpOptional;
            InputStreamReader reader = new InputStreamReader(response.body());
            try {
                JsonElement element = (JsonElement)Launcher.gsonManager.gson.fromJson((Reader)reader, JsonElement.class);
                httpOptional = this.applyJson(element, response.statusCode());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((Reader)reader).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            ((Reader)reader).close();
            return httpOptional;
        }
    }
}

