/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.profile;

import io.netty.channel.ChannelHandlerContext;
import java.util.UUID;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.ProfileByUUIDRequestEvent;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;

public class ProfileByUUIDResponse
extends SimpleResponse {
    public UUID uuid;
    public String client;

    @Override
    public String getType() {
        return "profileByUUID";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        AuthProviderPair pair = client.auth == null ? this.server.config.getAuthProviderPair() : client.auth;
        if (pair == null) {
            this.sendError("ProfileByUUIDResponse: AuthProviderPair is null");
            return;
        }
        User user = pair.core.getUserByUUID(this.uuid);
        if (user == null) {
            this.sendError("User not found");
            return;
        }
        this.sendResult((RequestEvent)new ProfileByUUIDRequestEvent(this.server.authManager.getPlayerProfile(pair, this.uuid)));
    }
}

