/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import com.google.gson.JsonElement;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.time.Duration;
import pro.gravit.launcher.Launcher;
import pro.gravit.launchserver.helper.HttpHelper;

public class HttpRequester {
    private final transient HttpClient httpClient = HttpClient.newBuilder().build();

    public <T> SimpleErrorHandler<T> makeEH(Class<T> clazz) {
        return new SimpleErrorHandler(clazz);
    }

    public <T> SimpleErrorHandler<T> makeEH(Type clazz) {
        return new SimpleErrorHandler(clazz);
    }

    public <T> HttpRequest get(String url, String token) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().method("GET", HttpRequest.BodyPublishers.noBody()).uri(new URI(url)).header("Content-Type", "application/json; charset=UTF-8").header("Accept", "application/json").timeout(Duration.ofMillis(10000L));
            if (token != null) {
                requestBuilder.header("Authorization", "Bearer ".concat(token));
            }
            return requestBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> HttpRequest post(String url, T request, String token) {
        try {
            HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().method("POST", HttpRequest.BodyPublishers.ofString(Launcher.gsonManager.gson.toJson(request))).uri(new URI(url)).header("Content-Type", "application/json; charset=UTF-8").header("Accept", "application/json").timeout(Duration.ofMillis(10000L));
            if (token != null) {
                requestBuilder.header("Authorization", "Bearer ".concat(token));
            }
            return requestBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public <T> HttpHelper.HttpOptional<T, SimpleError> send(HttpRequest request, Class<T> clazz) throws IOException {
        return HttpHelper.send(this.httpClient, request, this.makeEH(clazz));
    }

    public <T> HttpHelper.HttpOptional<T, SimpleError> send(HttpRequest request, Type type) throws IOException {
        return HttpHelper.send(this.httpClient, request, this.makeEH(type));
    }

    public static class SimpleErrorHandler<T>
    implements HttpHelper.HttpJsonErrorHandler<T, SimpleError> {
        private final Type type;

        private SimpleErrorHandler(Type type) {
            this.type = type;
        }

        @Override
        public HttpHelper.HttpOptional<T, SimpleError> applyJson(JsonElement response, int statusCode) {
            if (statusCode < 200 || statusCode >= 300) {
                return new HttpHelper.HttpOptional<Object, SimpleError>(null, (SimpleError)Launcher.gsonManager.gson.fromJson(response, SimpleError.class), statusCode);
            }
            if (this.type == Void.class) {
                return new HttpHelper.HttpOptional<Object, Object>(null, null, statusCode);
            }
            return new HttpHelper.HttpOptional<Object, Object>(Launcher.gsonManager.gson.fromJson(response, this.type), null, statusCode);
        }
    }

    public static class SimpleError {
        public String error;
        public int code;

        public SimpleError(String error) {
            this.error = error;
        }

        public String toString() {
            return "SimpleError{error='" + this.error + "', code=" + this.code + "}";
        }
    }
}

