/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.manangers;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.security.Key;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import javax.crypto.Cipher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.ClientPermissions;
import pro.gravit.launcher.profiles.ClientProfile;
import pro.gravit.launcher.profiles.PlayerProfile;
import pro.gravit.launcher.profiles.Texture;
import pro.gravit.launcher.request.auth.AuthRequest;
import pro.gravit.launcher.request.auth.password.Auth2FAPassword;
import pro.gravit.launcher.request.auth.password.AuthAESPassword;
import pro.gravit.launcher.request.auth.password.AuthMultiPassword;
import pro.gravit.launcher.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.request.auth.password.AuthPlainPassword;
import pro.gravit.launcher.request.auth.password.AuthRSAPassword;
import pro.gravit.launchserver.LaunchServer;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.AuthProviderPair;
import pro.gravit.launchserver.auth.core.AuthCoreProvider;
import pro.gravit.launchserver.auth.core.User;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.provider.AuthSupportExtendedCheckServer;
import pro.gravit.launchserver.auth.core.interfaces.session.UserSessionSupportKeys;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportProperties;
import pro.gravit.launchserver.auth.core.interfaces.user.UserSupportTextures;
import pro.gravit.launchserver.auth.texture.TextureProvider;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.auth.AuthResponse;
import pro.gravit.launchserver.socket.response.auth.RestoreResponse;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class AuthManager {
    private final transient LaunchServer server;
    private final transient Logger logger = LogManager.getLogger();
    private final transient JwtParser checkServerTokenParser;

    public AuthManager(LaunchServer server) {
        this.server = server;
        this.checkServerTokenParser = Jwts.parserBuilder().requireIssuer("LaunchServer").require("tokenType", (Object)"checkServer").setSigningKey((Key)server.keyAgreementManager.ecdsaPublicKey).build();
    }

    public String newCheckServerToken(String serverName, String authId) {
        return Jwts.builder().setIssuer("LaunchServer").claim("serverName", (Object)serverName).claim("authId", (Object)authId).claim("tokenType", (Object)"checkServer").signWith((Key)this.server.keyAgreementManager.ecdsaPrivateKey).compact();
    }

    public CheckServerTokenInfo parseCheckServerToken(String token) {
        try {
            Claims jwt = (Claims)this.checkServerTokenParser.parseClaimsJws(token).getBody();
            return new CheckServerTokenInfo((String)jwt.get("serverName", String.class), (String)jwt.get("authId", String.class));
        }
        catch (Exception e) {
            return null;
        }
    }

    public AuthResponse.AuthContext makeAuthContext(Client client, AuthResponse.ConnectTypes authType, AuthProviderPair pair, String login, String profileName, String ip) {
        Objects.requireNonNull(client, "Client must be not null");
        Objects.requireNonNull(authType, "authType must be not null");
        Objects.requireNonNull(pair, "AuthProviderPair must be not null");
        return new AuthResponse.AuthContext(client, login, profileName, ip, authType, pair);
    }

    public void check(AuthResponse.AuthContext context) throws AuthException {
        if (context.authType == AuthResponse.ConnectTypes.CLIENT && !context.client.checkSign) {
            throw new AuthException("Don't skip Launcher Update");
        }
        if (context.client.isAuth) {
            throw new AuthException("You are already logged in");
        }
    }

    public AuthReport auth(AuthResponse.AuthContext context, AuthRequest.AuthPasswordInterface password) throws AuthException {
        AuthCoreProvider provider = context.pair.core;
        provider.verifyAuth(context);
        if (password instanceof AuthOAuthPassword) {
            User user;
            UserSession session;
            AuthOAuthPassword password1 = (AuthOAuthPassword)password;
            try {
                session = provider.getUserSessionByOAuthAccessToken(password1.accessToken);
            }
            catch (AuthCoreProvider.OAuthAccessTokenExpired oAuthAccessTokenExpired) {
                throw new AuthException("auth.expiretoken");
            }
            if (session == null) {
                throw new AuthException("auth.invalidtoken");
            }
            context.client.coreObject = user = session.getUser();
            context.client.sessionObject = session;
            this.internalAuth(context.client, context.authType, context.pair, user.getUsername(), user.getUUID(), user.getPermissions(), true);
            if (context.authType == AuthResponse.ConnectTypes.CLIENT && this.server.config.protectHandler.allowGetAccessToken(context)) {
                return AuthReport.ofMinecraftAccessToken(session.getMinecraftAccessToken(), session);
            }
            return AuthReport.ofMinecraftAccessToken(null, session);
        }
        String login = context.login;
        try {
            User user;
            AuthReport result = provider.authorize(login, context, password, context.authType == AuthResponse.ConnectTypes.CLIENT && this.server.config.protectHandler.allowGetAccessToken(context));
            if (result == null || result.session == null || result.session.getUser() == null) {
                this.logger.error("AuthCoreProvider {} method 'authorize' return null", (Object)context.pair.name);
                throw new AuthException("Internal Auth Error");
            }
            UserSession session = result.session;
            context.client.coreObject = user = session.getUser();
            context.client.sessionObject = session;
            this.internalAuth(context.client, context.authType, context.pair, user.getUsername(), user.getUUID(), user.getPermissions(), result.isUsingOAuth());
            return result;
        }
        catch (IOException e) {
            if (e instanceof AuthException) {
                AuthException authException = (AuthException)e;
                throw authException;
            }
            this.logger.error((Object)e);
            throw new AuthException("Internal Auth Error");
        }
    }

    public void internalAuth(Client client, AuthResponse.ConnectTypes authType, AuthProviderPair pair, String username, UUID uuid, ClientPermissions permissions, boolean oauth) {
        if (!oauth) {
            throw new UnsupportedOperationException("Unsupported legacy session system");
        }
        client.isAuth = true;
        client.permissions = permissions;
        client.auth_id = pair.name;
        client.auth = pair;
        client.username = username;
        client.type = authType;
        client.uuid = uuid;
    }

    public UserSessionSupportKeys.ClientProfileKeys createClientProfileKeys(UUID playerUUID) {
        throw new UnsupportedOperationException("Minecraft 1.19.1 signature");
    }

    public CheckServerReport checkServer(Client client, String username, String serverID) throws IOException {
        if (client.auth == null) {
            return null;
        }
        AuthSupportExtendedCheckServer supportExtended = client.auth.core.isSupport(AuthSupportExtendedCheckServer.class);
        if (supportExtended != null) {
            UserSession session = supportExtended.extendedCheckServer(client, username, serverID);
            if (session == null) {
                return null;
            }
            return CheckServerReport.ofUserSession(session, this.getPlayerProfile(client.auth, session.getUser()));
        }
        User user = client.auth.core.checkServer(client, username, serverID);
        if (user == null) {
            return null;
        }
        return CheckServerReport.ofUser(user, this.getPlayerProfile(client.auth, user));
    }

    public boolean joinServer(Client client, String username, UUID uuid, String accessToken, String serverID) throws IOException {
        if (client.auth == null) {
            return false;
        }
        return client.auth.core.joinServer(client, username, uuid, accessToken, serverID);
    }

    public PlayerProfile getPlayerProfile(Client client) {
        if (client.auth == null) {
            return null;
        }
        User user = client.getUser();
        if (user == null) {
            return null;
        }
        PlayerProfile playerProfile = this.getPlayerProfile(client.auth, user);
        if (playerProfile != null) {
            return playerProfile;
        }
        if (client.auth.textureProvider != null) {
            return this.getPlayerProfile(client.uuid, client.username, client.profile == null ? null : client.profile.getTitle(), client.auth.textureProvider, new HashMap<String, String>());
        }
        return new PlayerProfile(client.uuid, client.username, new HashMap(), new HashMap());
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, String username) {
        return this.getPlayerProfile(pair, username, null);
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, String username, ClientProfile profile) {
        User user = pair.core.getUserByUsername(username);
        if (user == null) {
            return null;
        }
        PlayerProfile playerProfile = this.getPlayerProfile(pair, user);
        UUID uuid = user.getUUID();
        if (playerProfile != null) {
            return playerProfile;
        }
        if (uuid == null) {
            return null;
        }
        if (pair.textureProvider != null) {
            return this.getPlayerProfile(uuid, username, profile == null ? null : profile.getTitle(), pair.textureProvider, new HashMap<String, String>());
        }
        return new PlayerProfile(uuid, username, new HashMap(), new HashMap());
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, UUID uuid) {
        return this.getPlayerProfile(pair, uuid, null);
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, UUID uuid, ClientProfile profile) {
        User user = pair.core.getUserByUUID(uuid);
        if (user == null) {
            return null;
        }
        PlayerProfile playerProfile = this.getPlayerProfile(pair, user);
        String username = user.getUsername();
        if (playerProfile != null) {
            return playerProfile;
        }
        if (username == null) {
            return null;
        }
        if (pair.textureProvider != null) {
            return this.getPlayerProfile(uuid, username, profile == null ? null : profile.getTitle(), pair.textureProvider, new HashMap<String, String>());
        }
        return new PlayerProfile(uuid, username, new HashMap(), new HashMap());
    }

    public PlayerProfile getPlayerProfile(AuthProviderPair pair, User user) {
        HashMap<String, String> properties;
        if (user instanceof UserSupportProperties) {
            UserSupportProperties userSupportProperties = (UserSupportProperties)((Object)user);
            properties = userSupportProperties.getProperties();
        } else {
            properties = new HashMap();
        }
        if (user instanceof UserSupportTextures) {
            UserSupportTextures userSupportTextures = (UserSupportTextures)((Object)user);
            return new PlayerProfile(user.getUUID(), user.getUsername(), userSupportTextures.getUserAssets(), properties);
        }
        if (pair.textureProvider == null) {
            throw new NullPointerException("TextureProvider not found");
        }
        return this.getPlayerProfile(user.getUUID(), user.getUsername(), "", pair.textureProvider, properties);
    }

    private PlayerProfile getPlayerProfile(UUID uuid, String username, String client, TextureProvider textureProvider, Map<String, String> properties) {
        Map<String, Texture> assets = textureProvider.getAssets(uuid, username, client);
        return new PlayerProfile(uuid, username, assets, properties);
    }

    public AuthRequest.AuthPasswordInterface decryptPassword(AuthRequest.AuthPasswordInterface password) throws AuthException {
        if (password instanceof Auth2FAPassword) {
            Auth2FAPassword auth2FAPassword = (Auth2FAPassword)password;
            auth2FAPassword.firstPassword = this.tryDecryptPasswordPlain(auth2FAPassword.firstPassword);
            auth2FAPassword.secondPassword = this.tryDecryptPasswordPlain(auth2FAPassword.secondPassword);
        } else if (password instanceof AuthMultiPassword) {
            AuthMultiPassword multiPassword = (AuthMultiPassword)password;
            ArrayList<AuthRequest.AuthPasswordInterface> list = new ArrayList<AuthRequest.AuthPasswordInterface>(multiPassword.list.size());
            for (AuthRequest.AuthPasswordInterface p : multiPassword.list) {
                list.add(this.tryDecryptPasswordPlain(p));
            }
            multiPassword.list = list;
        } else {
            password = this.tryDecryptPasswordPlain(password);
        }
        return password;
    }

    private AuthRequest.AuthPasswordInterface tryDecryptPasswordPlain(AuthRequest.AuthPasswordInterface password) throws AuthException {
        if (password instanceof AuthAESPassword) {
            AuthAESPassword authAESPassword = (AuthAESPassword)password;
            try {
                return new AuthPlainPassword(IOHelper.decode((byte[])SecurityHelper.decrypt((String)this.server.runtime.passwordEncryptKey, (byte[])authAESPassword.password)));
            }
            catch (Exception ignored) {
                throw new AuthException("Password decryption error");
            }
        }
        if (password instanceof AuthRSAPassword) {
            AuthRSAPassword authRSAPassword = (AuthRSAPassword)password;
            try {
                Cipher cipher = SecurityHelper.newRSADecryptCipher((RSAPrivateKey)this.server.keyAgreementManager.rsaPrivateKey);
                return new AuthPlainPassword(IOHelper.decode((byte[])cipher.doFinal(authRSAPassword.password)));
            }
            catch (Exception ignored) {
                throw new AuthException("Password decryption error");
            }
        }
        return password;
    }

    public record CheckServerTokenInfo(String serverName, String authId) {
    }

    public record AuthReport(String minecraftAccessToken, String oauthAccessToken, String oauthRefreshToken, long oauthExpire, UserSession session) {
        public static AuthReport ofOAuth(String oauthAccessToken, String oauthRefreshToken, long oauthExpire, UserSession session) {
            return new AuthReport(null, oauthAccessToken, oauthRefreshToken, oauthExpire, session);
        }

        public static AuthReport ofOAuthWithMinecraft(String minecraftAccessToken, String oauthAccessToken, String oauthRefreshToken, long oauthExpire, UserSession session) {
            return new AuthReport(minecraftAccessToken, oauthAccessToken, oauthRefreshToken, oauthExpire, session);
        }

        public static AuthReport ofMinecraftAccessToken(String minecraftAccessToken, UserSession session) {
            return new AuthReport(minecraftAccessToken, null, null, 0L, session);
        }

        public boolean isUsingOAuth() {
            return this.oauthAccessToken != null || this.oauthRefreshToken != null;
        }
    }

    public static class CheckServerReport {
        public UUID uuid;
        public User user;
        public UserSession session;
        public PlayerProfile playerProfile;

        public CheckServerReport(UUID uuid, User user, UserSession session, PlayerProfile playerProfile) {
            this.uuid = uuid;
            this.user = user;
            this.session = session;
            this.playerProfile = playerProfile;
        }

        public static CheckServerReport ofUser(User user, PlayerProfile playerProfile) {
            return new CheckServerReport(user.getUUID(), user, null, playerProfile);
        }

        public static CheckServerReport ofUserSession(UserSession session, PlayerProfile playerProfile) {
            User user = session.getUser();
            return new CheckServerReport(user.getUUID(), user, session, playerProfile);
        }

        public static CheckServerReport ofUUID(UUID uuid, PlayerProfile playerProfile) {
            return new CheckServerReport(uuid, null, null, playerProfile);
        }
    }

    public static class CheckServerVerifier
    implements RestoreResponse.ExtendedTokenProvider {
        private final LaunchServer server;

        public CheckServerVerifier(LaunchServer server) {
            this.server = server;
        }

        @Override
        public boolean accept(Client client, AuthProviderPair pair, String extendedToken) {
            CheckServerTokenInfo info = this.server.authManager.parseCheckServerToken(extendedToken);
            if (info == null) {
                return false;
            }
            client.auth_id = info.authId;
            client.auth = this.server.config.getAuthProviderPair(info.authId);
            if (client.permissions == null) {
                client.permissions = new ClientPermissions();
            }
            client.permissions.addPerm("launchserver.checkserver");
            client.permissions.addPerm("launchserver.profile.%s.show".formatted(info.serverName));
            client.setProperty("launchserver.serverName", info.serverName);
            return true;
        }
    }
}

