/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.events.RequestEvent;
import pro.gravit.launcher.events.request.CheckServerRequestEvent;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.core.UserSession;
import pro.gravit.launchserver.auth.core.interfaces.session.UserSessionSupportHardware;
import pro.gravit.launchserver.auth.core.interfaces.session.UserSessionSupportProperties;
import pro.gravit.launchserver.manangers.AuthManager;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.HookException;

public class CheckServerResponse
extends SimpleResponse {
    private final transient Logger logger = LogManager.getLogger();
    public String serverID;
    public String username;
    public boolean needHardware;
    public boolean needProperties;

    @Override
    public String getType() {
        return "checkServer";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client pClient) {
        if (pClient.permissions == null || !pClient.permissions.hasPerm("launchserver.checkserver")) {
            this.sendError("Permissions denied");
            return;
        }
        CheckServerRequestEvent result = new CheckServerRequestEvent();
        try {
            this.server.authHookManager.checkServerHook.hook((Object)this, (Object)pClient);
            AuthManager.CheckServerReport report = this.server.authManager.checkServer(pClient, this.username, this.serverID);
            if (report == null) {
                this.sendError("User not verified");
                return;
            }
            result.playerProfile = report.playerProfile;
            result.uuid = report.uuid;
            if (report.session != null) {
                UserSession userSession;
                result.sessionId = report.session.getID();
                if (this.needProperties && (userSession = report.session) instanceof UserSessionSupportProperties) {
                    UserSessionSupportProperties supportProperties = (UserSessionSupportProperties)((Object)userSession);
                    result.sessionProperties = supportProperties.getProperties();
                }
                if (this.needHardware && (userSession = report.session) instanceof UserSessionSupportHardware) {
                    UserSessionSupportHardware supportHardware = (UserSessionSupportHardware)((Object)userSession);
                    result.hardwareId = supportHardware.getHardwareId();
                }
            }
            this.server.authHookManager.postCheckServerHook.hook((Object)report, (Object)pClient);
            this.logger.debug("checkServer: {} uuid: {} serverID: {}", (Object)(result.playerProfile == null ? null : result.playerProfile.username), (Object)result.uuid, (Object)this.serverID);
        }
        catch (AuthException | HookException e) {
            this.sendError(e.getMessage());
            return;
        }
        catch (Exception e) {
            this.logger.error("Internal authHandler error", (Throwable)e);
            this.sendError("Internal authHandler error");
            return;
        }
        this.sendResult((RequestEvent)result);
    }
}

