/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import pro.gravit.launchserver.LaunchServerStarter;
import pro.gravit.launchserver.holder.LaunchServerControlHolder;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.launch.ClassLoaderControl;
import pro.gravit.utils.launch.LaunchOptions;
import pro.gravit.utils.launch.ModuleLaunch;

public class Main {
    private static final List<String> classpathOnly = List.of("proguard", "jline", "kotlin", "epoll");
    private static final String LOG4J_PROPERTY = "log4j2.configurationFile";

    private static boolean isClasspathOnly(Path path) {
        String fileName = path.getFileName().toString();
        for (String e : classpathOnly) {
            if (!fileName.contains(e)) continue;
            return true;
        }
        return false;
    }

    private static void unpackLog4j() {
        String log4jConfigurationFile = System.getProperty(LOG4J_PROPERTY);
        if (log4jConfigurationFile == null) {
            Path log4jConfigPath = Path.of("log4j2.xml", new String[0]);
            if (!Files.exists(log4jConfigPath, new LinkOption[0])) {
                try (FileOutputStream output = new FileOutputStream(log4jConfigPath.toFile());
                     InputStream input = Main.class.getResourceAsStream("/log4j2.xml");){
                    if (input == null) {
                        return;
                    }
                    input.transferTo(output);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            System.setProperty(LOG4J_PROPERTY, log4jConfigPath.toAbsolutePath().toString());
        }
    }

    public static void main(String[] args) throws Throwable {
        ArrayList<Path> libraries;
        Main.unpackLog4j();
        ModuleLaunch launch = new ModuleLaunch();
        LaunchOptions options = new LaunchOptions();
        options.moduleConf = new LaunchOptions.ModuleConf();
        try (Stream<Path> files = Files.walk(Path.of("libraries", new String[0]), FileVisitOption.FOLLOW_LINKS);){
            libraries = new ArrayList<Path>(files.filter(e -> e.getFileName().toString().endsWith(".jar")).toList());
        }
        ArrayList<Path> classpath = new ArrayList<Path>();
        ArrayList<String> modulepath = new ArrayList<String>();
        for (Path l : libraries) {
            if (Main.isClasspathOnly(l)) {
                classpath.add(l);
                continue;
            }
            modulepath.add(l.toAbsolutePath().toString());
        }
        classpath.add(IOHelper.getCodeSource(LaunchServerStarter.class));
        options.moduleConf.modulePath.addAll(modulepath);
        options.moduleConf.modules.add("ALL-MODULE-PATH");
        ClassLoaderControl control = launch.init(classpath, "natives", options);
        control.clearLauncherPackages();
        control.addLauncherPackage("pro.gravit.utils.launch");
        control.addLauncherPackage("pro.gravit.launchserver.holder");
        ModuleLayer.Controller controller = (ModuleLayer.Controller)control.getJava9ModuleController();
        LaunchServerControlHolder.setControl(control);
        LaunchServerControlHolder.setController(controller);
        launch.launch("pro.gravit.launchserver.LaunchServerStarter", null, Arrays.asList(args));
    }
}

