/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launchserver.socket.response.auth;

import io.netty.channel.ChannelHandlerContext;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.JoinServerRequestEvent;
import pro.gravit.launchserver.auth.AuthException;
import pro.gravit.launchserver.auth.protect.ProtectHandler;
import pro.gravit.launchserver.auth.protect.interfaces.JoinServerProtectHandler;
import pro.gravit.launchserver.socket.Client;
import pro.gravit.launchserver.socket.response.SimpleResponse;
import pro.gravit.utils.HookException;

public class JoinServerResponse
extends SimpleResponse {
    private final transient Logger logger = LogManager.getLogger();
    public String serverID;
    public String accessToken;
    public String username;
    public UUID uuid;

    @Override
    public String getType() {
        return "joinServer";
    }

    @Override
    public void execute(ChannelHandlerContext ctx, Client client) {
        boolean success;
        if (!this.server.config.protectHandler.allowJoinServer(client)) {
            this.sendError("Permissions denied");
            return;
        }
        if (this.username == null && this.uuid == null || this.accessToken == null || this.serverID == null) {
            this.sendError("Invalid request");
            return;
        }
        try {
            JoinServerProtectHandler joinServerProtectHandler;
            this.server.authHookManager.joinServerHook.hook((Object)this, (Object)client);
            ProtectHandler protectHandler = this.server.config.protectHandler;
            if (protectHandler instanceof JoinServerProtectHandler && !(success = (joinServerProtectHandler = (JoinServerProtectHandler)((Object)protectHandler)).onJoinServer(this.serverID, this.username, this.uuid, client))) {
                this.sendResult((RequestEvent)new JoinServerRequestEvent(false));
                return;
            }
            success = this.server.authManager.joinServer(client, this.username, this.uuid, this.accessToken, this.serverID);
            if (success) {
                this.logger.debug("joinServer: {} accessToken: {} serverID: {}", (Object)this.username, (Object)this.accessToken, (Object)this.serverID);
            }
        }
        catch (SecurityException | AuthException | HookException e) {
            this.sendError(e.getMessage());
            return;
        }
        catch (Exception e) {
            this.logger.error("Join Server error", (Throwable)e);
            this.sendError("Internal authHandler error");
            return;
        }
        this.sendResult((RequestEvent)new JoinServerRequestEvent(success));
    }
}

